/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public final class GenerationUtil {
    public static final Predicate<BlockState> IS_AIR = BlockBehaviour.BlockStateBase::isAir;

    public static Predicate<BlockState> isFluid(int minLevel, TagKey<Fluid> allowedFluids) {
        return state -> {
            FluidState fluid = state.getFluidState();
            return !fluid.isEmpty() && fluid.getOwnHeight() >= (float)minLevel && fluid.is(allowedFluids);
        };
    }

    public static void fillAreaWithBlockCube(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.set(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.getBlockState((BlockPos)positions))) continue;
                    level.setBlock((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCube(LevelAccessor level, RandomSource randomSource, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, WeightedRandomList<WeightedStateEntry> states) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.set(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.getBlockState((BlockPos)positions))) continue;
                    level.setBlock((BlockPos)positions, ((WeightedStateEntry)states.getRandom(randomSource).get()).getState(), 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.set(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.getBlockState((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    level.setBlock((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(LevelAccessor level, RandomSource randomSource, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, WeightedRandomList<WeightedStateEntry> states) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.set(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.getBlockState((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    level.setBlock((BlockPos)positions, ((WeightedStateEntry)states.getRandom(randomSource).get()).getState(), 2);
                }
            }
        }
    }

    public static class WeightedStateEntry
    implements WeightedEntry {
        private final BlockState state;
        private final Weight weight;

        public WeightedStateEntry(BlockState state, int weight) {
            this.state = state;
            this.weight = Weight.of((int)weight);
        }

        public BlockState getState() {
            return this.state;
        }

        public Weight getWeight() {
            return this.weight;
        }
    }
}

