/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.comparator.DoubleComparator;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class AttributeCondition
implements Condition {
    public static final Codec<AttributeCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap(CodecUtil.ATTRIBUTE_CODEC, DoubleComparator.CODEC).fieldOf("attribute_is").forGetter(attributeCondition -> attributeCondition.attributeComparator)).apply((Applicative)builder, AttributeCondition::new));
    private final Map<Attribute, DoubleComparator> attributeComparator;
    private final Set<Map.Entry<Attribute, DoubleComparator>> entries;

    public AttributeCondition(Map<Attribute, DoubleComparator> attributeComparator) {
        this.attributeComparator = attributeComparator;
        this.entries = attributeComparator.entrySet();
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        if (this.attributeComparator.isEmpty()) {
            return false;
        }
        for (Map.Entry<Attribute, DoubleComparator> entry : this.entries) {
            AttributeInstance attribute = conditionContext.entity().getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)entry.getKey()));
            if (attribute == null) {
                return false;
            }
            if (entry.getValue().check(attribute.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

