/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.chiseled_bookshelf;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.scholar.client.chiseled_bookshelf.BookshelfDefaultColors;
import io.github.mortuusars.scholar.client.chiseled_bookshelf.ChiseledBookshelfColors;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class BookshelfDefaultColorsReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<Map<ResourceLocation, BookshelfDefaultColors>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, BookshelfDefaultColors.CODEC);

    public BookshelfDefaultColorsReloadListener() {
        super(new Gson(), "chiseled_bookshelf/default_colors");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap bookshelfColors = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (!location.getNamespace().equals("scholar")) {
                LOGGER.info("Ignoring chiseled bookshelf default color definition '{}' because it's not in Scholar namespace.", (Object)location);
                continue;
            }
            CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).ifError(err -> LOGGER.error("Contents of '{}' cannot be parsed as a valid id to color list map: {}", (Object)location, err)).ifSuccess(data -> bookshelfColors.putAll((Map)data.getFirst()));
        }
        ChiseledBookshelfColors.DEFAULT_SLOT_COLORS = ImmutableMap.copyOf(bookshelfColors);
    }
}

