/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import org.jetbrains.annotations.NotNull;

public interface BookViewAccess {
    public static final BookViewAccess EMPTY = new BookViewAccess(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return FormattedText.EMPTY;
        }
    };

    public int getPageCount();

    public FormattedText getPageRaw(int var1);

    default public FormattedText getPage(int pageIndex) {
        return pageIndex >= 0 && pageIndex < this.getPageCount() ? this.getPageRaw(pageIndex) : FormattedText.EMPTY;
    }

    public static BookViewAccess fromItem(ItemStack itemStack) {
        if (itemStack.getItem() instanceof WrittenBookItem) {
            return new WrittenBookAccess(itemStack);
        }
        if (itemStack.getItem() instanceof WritableBookItem) {
            return new WritableBookAccess(itemStack);
        }
        return EMPTY;
    }

    public static List<String> loadPages(CompoundTag compoundTag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        BookViewAccess.loadPages(compoundTag, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void loadPages(CompoundTag compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        ListTag listTag = compoundTag.getList("pages", 8).copy();
        if (Minecraft.getInstance().isTextFilteringEnabled() && compoundTag.contains("filtered_pages", 10)) {
            CompoundTag compoundTag2 = compoundTag.getCompound("filtered_pages");
            intFunction = ix -> {
                String string = String.valueOf(ix);
                return compoundTag2.contains(string) ? compoundTag2.getString(string) : listTag.getString(ix);
            };
        } else {
            Objects.requireNonNull(listTag);
            intFunction = arg_0 -> ((ListTag)listTag).getString(arg_0);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            consumer.accept(intFunction.apply(i));
        }
    }

    public static class WrittenBookAccess
    implements BookViewAccess {
        private final List<Component> pages;

        public WrittenBookAccess(ItemStack itemStack) {
            this.pages = WrittenBookAccess.readPages(itemStack);
        }

        private static List<Component> readPages(ItemStack itemStack) {
            WrittenBookContent content = (WrittenBookContent)itemStack.getOrDefault(DataComponents.WRITTEN_BOOK_CONTENT, (Object)WrittenBookContent.EMPTY);
            return content.getPages(Minecraft.getInstance().isTextFilteringEnabled());
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        @NotNull
        public FormattedText getPageRaw(int i) {
            return (FormattedText)this.pages.get(i);
        }
    }

    public static class WritableBookAccess
    implements BookViewAccess {
        private final List<String> pages;

        public WritableBookAccess(ItemStack itemStack) {
            this.pages = WritableBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(ItemStack itemStack) {
            WritableBookContent content = (WritableBookContent)itemStack.getOrDefault(DataComponents.WRITABLE_BOOK_CONTENT, (Object)WritableBookContent.EMPTY);
            return content.getPages(Minecraft.getInstance().isTextFilteringEnabled()).toList();
        }

        @Override
        public int getPageCount() {
            return 100;
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return i >= this.pages.size() ? FormattedText.EMPTY : FormattedText.of((String)this.pages.get(i));
        }
    }
}

