/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.neoforge.event;

import io.github.mortuusars.scholar.network.neoforge.PacketsImpl;
import io.github.mortuusars.scholar.network.packet.C2SPackets;
import io.github.mortuusars.scholar.network.packet.CommonPackets;
import io.github.mortuusars.scholar.network.packet.S2CPackets;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class CommonEvents {

    public static class GameBus {
    }

    @EventBusSubscriber(modid="scholar", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                CauldronInteraction.WATER.map().put(Items.WRITABLE_BOOK, CauldronInteraction.DYED_ITEM);
                CauldronInteraction.WATER.map().put(Items.WRITTEN_BOOK, CauldronInteraction.DYED_ITEM);
            });
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : S2CPackets.getDefinitions()) {
                registrar.playToClient(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : C2SPackets.getDefinitions()) {
                registrar.playToServer(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : CommonPackets.getDefinitions()) {
                registrar.playBidirectional(definition.type(), definition.codec(), PacketsImpl::handle);
            }
        }
    }
}

