/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.additionalstructures.utils;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import xxrexraptorxx.additionalstructures.main.AdditionalStructures;
import xxrexraptorxx.additionalstructures.utils.Config;

@EventBusSubscriber(modid="additionalstructures", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static boolean hasShownUp = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (Config.UPDATE_CHECKER != null && ((Boolean)Config.UPDATE_CHECKER.get()).booleanValue() && !hasShownUp && Minecraft.getInstance().screen == null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            ModContainer modContainer = ModList.get().getModContainerById("additionalstructures").orElse(null);
            if (modContainer != null) {
                VersionChecker.CheckResult versionCheckResult = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
                if (versionCheckResult.status() == VersionChecker.Status.OUTDATED || versionCheckResult.status() == VersionChecker.Status.BETA_OUTDATED) {
                    MutableComponent url = Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Click here to update!"));
                    url.withStyle(url.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/additional-structures")));
                    player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "A newer version of " + String.valueOf(ChatFormatting.YELLOW) + "Additional Structures" + String.valueOf(ChatFormatting.BLUE) + " is available!")), false);
                    player.displayClientMessage((Component)url, false);
                    hasShownUp = true;
                } else if (versionCheckResult.status() == VersionChecker.Status.FAILED) {
                    AdditionalStructures.LOGGER.error("Additional Structures's version checker failed!");
                    hasShownUp = true;
                }
            }
        }
    }

    @SubscribeEvent
    public static void SupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (Config.PATREON_REWARDS != null && ((Boolean)Config.PATREON_REWARDS.get()).booleanValue()) {
            try {
                ServerPlayer serverPlayer;
                URL SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter");
                URL PREMIUM_SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter");
                URL ELITE_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite");
                if (!player.getInventory().contains(new ItemStack((ItemLike)Items.PAPER)) && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)Stats.PLAY_TIME) < 5) {
                    if (Events.SupporterCheck(SUPPORTER_URL, player)) {
                        ItemStack certificate = new ItemStack((ItemLike)Items.PAPER);
                        certificate.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Thank you for supporting me in my work!").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" - XxRexRaptorxX").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GREEN)));
                        ItemStack reward = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                        GameProfile profile = new GameProfile(player.getUUID(), player.getName().getString());
                        reward.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
                        level.playSound((Player)null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                        player.addItem(reward);
                        player.addItem(certificate);
                    }
                    if (Events.SupporterCheck(PREMIUM_SUPPORTER_URL, player)) {
                        ItemStack reward = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
                        Registry enchantmentsRegistry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                        reward.enchant((Holder)enchantmentsRegistry.getHolderOrThrow(Enchantments.MENDING), 1);
                        reward.enchant((Holder)enchantmentsRegistry.getHolderOrThrow(Enchantments.SHARPNESS), 3);
                        reward.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)reward.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
                        reward.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Rex's Night Sword").withStyle(ChatFormatting.DARK_GRAY));
                        player.addItem(reward);
                    }
                    if (Events.SupporterCheck(ELITE_URL, player)) {
                        ItemStack star = new ItemStack((ItemLike)Items.NETHER_STAR);
                        star.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Elite Star"));
                        player.addItem(star);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean SupporterCheck(URL url, Player player) {
        try {
            Scanner scanner = new Scanner(url.openStream());
            List<String> supporterList = scanner.tokens().toList();
            for (String name : supporterList) {
                if (!player.getName().getString().equals(name)) continue;
                return true;
            }
            scanner.close();
        }
        catch (MalformedURLException e) {
            AdditionalStructures.LOGGER.error("Supporter list URL not found! >>" + String.valueOf(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Path configDir = FMLPaths.CONFIGDIR.get();
        Path marker = configDir.resolve("#STOP_MOD_REPOSTS.txt");
        try {
            if (Files.notExists(marker, new LinkOption[0])) {
                String fileContent = "    Sites like 9minecraft.net, mc-mod.net, and many others, are known for reuploading mod files without permission from the authors. These sites will also contain a bunch of ads, to try to make money from mods they did not create.\n\n    These sites will use various methods to appear higher in Google when you search for the mod name, so a lot of people will download mods from them instead of the proper place. If you were linked to this site, you're one of these people.\n\n    FOR YOU, AS A PLAYER, THIS CAN MEAN ANY OF THE FOLLOWING:\n    > Getting versions of the mods advertised for the wrong Minecraft versions, which will 100% crash when you load them.\n    > Getting old, and broken, versions of the mods, possibly causing problems in your game.\n    > Getting modified versions of the mods, which may contain malware and viruses.\n    > Having your information stolen from malicious ads in the sites.\n    > Taking money and views away from the official authors, which may cause them to stop making new mods.\n\n    WHAT DO I DO NOW?\n    The most important thing to do now is to make sure you stop visiting these sites, and get the mods from official sources. We also recommend you do the following:\n\n    > Delete all the mods you've downloaded from these sites.\n    > Install the StopModReposts plugin, which makes sure you never visit them again.\n    > Run a virus/malware scan. We recommend MalwareBytes.\n    > Check out the #StopModReposts campaign, that tries to put an end to these sites. (https://stopmodreposts.org/)\n    > Spread the word. If you have any friends that use these sites, inform them to keep them safe.\n\n    WHERE DO I GET MODS NOW?\n    Here's a bunch of links to places where you can download official versions of mods, hosted by their real authors:\n\n    > CurseForge, where most modders host their mods. If it exists, it's probably there.\n    > Modrinth, a new hosting platform for mods that's also legit and more popular by the day.\n    > OptiFine.net, the official OptiFine site.\n    > Neoforged.net, which you need for any other Neoforge mods.\n    > FabricMC.net, which you need for any other Fabric mods.\n    > MinecraftForge Files, which you need for any other Forge mods.\n\n    This doesn't mean other sites aren't legit. In general, the first place to look for a mod is CurseForge and Modrinth, so look there first.\n\n    FAQ\n    Q: What if I've never had problems before?\n    > Just because you've never had problems with these sites before doesn't mean they're good. You should still avoid them for all the reasons listed above.\n\n    Q: Is there a list of these sites I can check out?\n    > Yes, however, due to these showing up all the time, it's possible to be incomplete. (https://github.com/StopModReposts/Illegal-Mod-Sites/blob/master/SITES.md)\n\n    Q: Why can't you just take these sites down?\n    > Unfortunately, these sites are often hosted in countries like Russia or Vietnam, where doing so isn't as feasible.\n\n    Q: What if it says \"Official Download\" on the sites?\n    > Sometimes they'll do that to trick you. If you're uncertain, you should verify with the StopModReposts list linked above.\n\n\n    Credits: XxRexRaptorxX, Vazkii, StopModReposts campaign\n";
                Files.writeString(marker, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            AdditionalStructures.LOGGER.error((Object)e);
        }
    }
}

