/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.PillagerCaravans;
import dev.obscuria.caravans.content.IHorseExtension;
import dev.obscuria.caravans.content.ILivingExtension;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public record CaravanMember(EntityType<?> type, Optional<Item> armorItem, Optional<ResourceLocation> lootTable, Optional<ResourceKey<LootTable>> cargoTable, int count) {
    public static final Codec<CaravanMember> CODEC;
    public static boolean generatingCaravanCargo;
    private static final ResourceLocation CARAVAN_MODIFIER;

    @Nullable
    public Entity spawn(Holder<CaravanVariation> variation, ServerLevel level, BlockPos pos, boolean isLeader) {
        AbstractHorse horse;
        Animal animal;
        AttributeInstance attribute;
        FluidState fluidState;
        BlockState state = level.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)state, (FluidState)(fluidState = state.getFluidState()), this.type)) {
            return null;
        }
        Entity entity = this.type.create((Level)level);
        if (entity == null) {
            return null;
        }
        entity.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ILivingExtension.setCaravanMember(living, true);
        }
        if (isLeader && entity instanceof PatrollingMonster) {
            PatrollingMonster monster = (PatrollingMonster)entity;
            monster.setPatrolLeader(true);
            monster.findPatrolTarget();
            ResourceLocation type = variation.unwrapKey().map(ResourceKey::location).orElse(null);
            ILivingExtension.setCaravanType((LivingEntity)monster, type);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            DifficultyInstance difficulty = level.getCurrentDifficultyAt(pos);
            mob.finalizeSpawn((ServerLevelAccessor)level, difficulty, MobSpawnType.PATROL, null);
        }
        if (entity instanceof Animal && (attribute = (animal = (Animal)entity).getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            attribute.addPermanentModifier(this.makeAnimalSpeedModifier());
        }
        if (entity instanceof AbstractHorse) {
            horse = (AbstractHorse)entity;
            horse.setTamed(true);
            this.armorItem.ifPresent(armor -> horse.setBodyArmorItem(armor.getDefaultInstance()));
        }
        if (entity instanceof AbstractChestedHorse) {
            horse = (AbstractChestedHorse)entity;
            horse.setChest(true);
            IHorseExtension.createInventory(horse);
            this.cargoTable.ifPresent(arg_0 -> this.lambda$spawn$1(level, (AbstractChestedHorse)horse, arg_0));
        }
        level.addFreshEntityWithPassengers(entity);
        return entity;
    }

    private void generateCargo(ServerLevel level, AbstractChestedHorse entity, ResourceKey<LootTable> cargo) {
        SimpleContainer inventory = IHorseExtension.getInventory((AbstractHorse)entity);
        LootTable table = level.getServer().reloadableRegistries().getLootTable(cargo);
        LootParams params = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).create(LootContextParamSets.CHEST);
        generatingCaravanCargo = true;
        inventory.setItem(0, Items.STRUCTURE_VOID.getDefaultInstance());
        table.fill((Container)IHorseExtension.getInventory((AbstractHorse)entity), params, entity.getLootTableSeed());
        inventory.setItem(0, ItemStack.EMPTY);
        generatingCaravanCargo = false;
    }

    private AttributeModifier makeAnimalSpeedModifier() {
        return new AttributeModifier(CARAVAN_MODIFIER, -0.33, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private /* synthetic */ void lambda$spawn$1(ServerLevel level, AbstractChestedHorse horse, ResourceKey cargo) {
        this.generateCargo(level, horse, (ResourceKey<LootTable>)cargo);
    }

    static {
        CARAVAN_MODIFIER = PillagerCaravans.key("caravan_modifier");
        CODEC = RecordCodecBuilder.create(codec -> codec.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(CaravanMember::type), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("armor").forGetter(CaravanMember::armorItem), (App)ResourceLocation.CODEC.optionalFieldOf("loot_table").forGetter(CaravanMember::lootTable), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).optionalFieldOf("cargo").forGetter(CaravanMember::cargoTable), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(CaravanMember::count)).apply((Applicative)codec, CaravanMember::new));
    }
}

