/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.content.IWeighted;
import dev.obscuria.caravans.content.caravan.CaravanPool;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record CaravanPlacement(int weight, HolderSet<Biome> biomes, @Unmodifiable List<CaravanPool> pools) implements IWeighted
{
    public static final Codec<Holder<CaravanPlacement>> CODEC = RegistryFixedCodec.create(CaravanRegistries.Keys.PLACEMENT);
    public static final Codec<CaravanPlacement> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("weight").forGetter(CaravanPlacement::weight), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(CaravanPlacement::biomes), (App)CaravanPool.CODEC.listOf().fieldOf("pools").forGetter(CaravanPlacement::pools)).apply((Applicative)codec, CaravanPlacement::new));

    public boolean isFor(Holder<Biome> biome) {
        return this.biomes.contains(biome);
    }

    @Nullable
    public Holder<CaravanVariation> getRandomVariation(RandomSource random) {
        CaravanPool pool = IWeighted.pickRandom(this.pools, random);
        return pool == null ? null : pool.getRandomVariation(random);
    }
}

