/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.config.CommonConfig;
import dev.obscuria.caravans.content.caravan.CaravanMember;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record CaravanVariation(int cooldown, CaravanMember leader, @Unmodifiable List<CaravanMember> members) {
    public static final Codec<Holder<CaravanVariation>> CODEC = RegistryFixedCodec.create(CaravanRegistries.Keys.VARIATION);
    public static final Codec<CaravanVariation> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("cooldown").forGetter(CaravanVariation::cooldown), (App)CaravanMember.CODEC.fieldOf("leader").forGetter(CaravanVariation::leader), (App)CaravanMember.CODEC.listOf().fieldOf("members").forGetter(CaravanVariation::members)).apply((Applicative)codec, CaravanVariation::new));

    public int actualCooldown() {
        return (int)((double)this.cooldown * (Double)CommonConfig.SPAWN_COOLDOWN_MULTIPLIER.get());
    }

    public int spawn(Holder<CaravanVariation> self, ServerLevel level, BlockPos position) {
        RandomSource random = level.random;
        BlockPos.MutableBlockPos pos = position.mutable();
        pos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos).getY());
        if (this.leader.spawn(self, level, (BlockPos)pos, true) == null) {
            return 0;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (CaravanMember member : this.members) {
            for (int i = 0; i < member.count(); ++i) {
                pos.setX(pos.getX() + random.nextInt(3) - random.nextInt(3));
                pos.setZ(pos.getZ() + random.nextInt(3) - random.nextInt(3));
                pos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos).getY());
                Entity entity = member.spawn(self, level, (BlockPos)pos, false);
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        this.leashAnimals(entities, random);
        return 1 + entities.size();
    }

    private void leashAnimals(List<Entity> entities, RandomSource random) {
        @Nullable Animal lastAnimal = null;
        ArrayList holders = entities.stream().filter(this::isValidLeashHolder).collect(Collectors.toCollection(ArrayList::new));
        for (Entity member : entities) {
            if (!(member instanceof Animal)) continue;
            Animal animal = (Animal)member;
            if (lastAnimal != null && random.nextInt(4) < 3) {
                animal.setLeashedTo(lastAnimal, true);
            } else {
                Entity holder;
                Collections.shuffle(holders);
                Entity entity = holder = holders.isEmpty() ? null : (Entity)holders.get(0);
                if (holder != null) {
                    animal.setLeashedTo(holder, true);
                }
            }
            lastAnimal = animal;
        }
    }

    private boolean isValidLeashHolder(Entity entity) {
        return entity instanceof AbstractIllager;
    }
}

