/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.obscuria.caravans.content.caravan.CaravanSpawner;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import dev.obscuria.caravans.mixin.ResourceKeyArgumentAccessor;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class CaravanCommand {
    private static final DynamicCommandExceptionType ERR_INVALID_VARIATION = new DynamicCommandExceptionType(it -> Component.translatable((String)"commands.caravan.spawn.invalid", (Object[])new Object[]{it}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"caravan").requires(it -> it.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cooldown").then(Commands.literal((String)"get").executes(it -> CaravanCommand.getCooldown((CommandSourceStack)it.getSource())))).then(Commands.literal((String)"reset").executes(it -> CaravanCommand.resetCooldown((CommandSourceStack)it.getSource())))).then(Commands.literal((String)"set").then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(it -> CaravanCommand.setCooldown((CommandSourceStack)it.getSource(), IntegerArgumentType.getInteger((CommandContext)it, (String)"ticks"))))))).then(Commands.literal((String)"spawn").then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"variation", (ArgumentType)ResourceKeyArgument.key(CaravanRegistries.Keys.VARIATION)).executes(it -> CaravanCommand.spawn((CommandSourceStack)it.getSource(), BlockPosArgument.getBlockPos((CommandContext)it, (String)"position"), CaravanCommand.getCaravansVariation((CommandContext<CommandSourceStack>)it, "variation")))))));
    }

    public static int getCooldown(CommandSourceStack source) {
        int ticks = CaravanSpawner.INSTANCE.cooldownTick;
        source.sendSuccess(() -> Component.translatable((String)"commands.caravan.cooldown.get", (Object[])new Object[]{ticks}), false);
        return ticks;
    }

    public static int resetCooldown(CommandSourceStack source) {
        CaravanSpawner.INSTANCE.cooldownTick = 0;
        source.sendSuccess(() -> Component.translatable((String)"commands.caravan.cooldown.reset"), true);
        return 1;
    }

    public static int setCooldown(CommandSourceStack source, int ticks) {
        CaravanSpawner.INSTANCE.cooldownTick = ticks;
        source.sendSuccess(() -> Component.translatable((String)"commands.caravan.cooldown.set", (Object[])new Object[]{ticks}), true);
        return 1;
    }

    private static int spawn(CommandSourceStack source, BlockPos pos, Holder.Reference<CaravanVariation> variation) {
        ResourceLocation id = variation.key().location();
        source.sendSuccess(() -> Component.translatable((String)"commands.caravan.spawn.success", (Object[])new Object[]{id.toString(), pos.getX(), pos.getY(), pos.getZ()}), true);
        return ((CaravanVariation)variation.value()).spawn((Holder<CaravanVariation>)variation, source.getLevel(), pos);
    }

    private static Holder.Reference<CaravanVariation> getCaravansVariation(CommandContext<CommandSourceStack> context, String name) {
        return ResourceKeyArgumentAccessor.invokeResolveKey(context, name, CaravanRegistries.Keys.VARIATION, ERR_INVALID_VARIATION);
    }
}

