/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassCloche
extends RotatableBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_CLOCHE = GlassCloche.makeShape_Cloche();
    private static final VoxelShape SHAPE_NO_CLOCHE = GlassCloche.makeShape_NoCloche();
    public static final BooleanProperty CLOCHE = BooleanProperty.create((String)"cloche");
    public static final BooleanProperty ANIMATED = BooleanProperty.create((String)"animated");

    public GlassCloche(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CLOCHE, (Comparable)Boolean.valueOf(true))).setValue((Property)ANIMATED, (Comparable)Boolean.valueOf(true)));
    }

    public static VoxelShape makeShape_Cloche() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.9375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.9375, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_NoCloche() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        returnShape = (Boolean)state.getValue((Property)CLOCHE) != false ? SHAPE_CLOCHE : SHAPE_NO_CLOCHE;
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        returnShape = (Boolean)state.getValue((Property)CLOCHE) != false ? SHAPE_CLOCHE : SHAPE_NO_CLOCHE;
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        GlassClocheBlockEntity gce = (GlassClocheBlockEntity)world.getBlockEntity(pos);
        player.openMenu((MenuProvider)gce);
        return InteractionResult.CONSUME;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional<BlockState> newState;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.CLOCK) && (newState = GlassCloche.isAnimated(state, world, pos, player, hand, hit)).isPresent()) {
            world.setBlock(pos, newState.get(), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Optional<BlockState> isAnimated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item;
        if (player.getAbilities().mayBuild && hand == InteractionHand.MAIN_HAND && (item = player.getItemInHand(InteractionHand.MAIN_HAND)).is(Items.CLOCK)) {
            world.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.2f + 1.0f);
            BlockState newState = (BlockState)state.cycle((Property)ANIMATED);
            return Optional.of(newState);
        }
        return Optional.empty();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = world.getBlockEntity(pos);
            if (tileentity instanceof GlassClocheBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((GlassClocheBlockEntity)tileentity));
                world.updateNeighborsAt(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof GlassClocheBlockEntity) {
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(DataComponents.CUSTOM_NAME, (Object)customName);
            ((GlassClocheBlockEntity)tileentity).setComponents(builder.build());
        }
    }

    public static void swapCloche(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState newState = (BlockState)state.cycle((Property)CLOCHE);
        if (!world.isClientSide()) {
            world.setBlock(pos, newState, 3);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{CLOCHE}).add(new Property[]{ANIMATED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GlassClocheBlockEntity(pos, state);
    }
}

