/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KatanaStand
extends RotatableBlock
implements EntityBlock {
    private static VoxelShape SHAPE_NS = KatanaStand.makeShape_NS();
    private static VoxelShape SHAPE_EW = KatanaStand.makeShape_EW();

    public KatanaStand(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape makeShape_NS() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.375, (double)0.9375, (double)0.0625, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.375, (double)0.25, (double)0.0625, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.046875, (double)0.0625, (double)0.359375, (double)0.953125, (double)0.125, (double)0.640625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.4375, (double)0.1875, (double)0.475, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.125, (double)0.4375, (double)0.875, (double)0.475, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_EW() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0625, (double)0.625, (double)0.0625, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.75, (double)0.625, (double)0.0625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.359375, (double)0.0625, (double)0.046875, (double)0.640625, (double)0.125, (double)0.953125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.125, (double)0.8125, (double)0.5625, (double)0.475, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.125, (double)0.125, (double)0.5625, (double)0.475, (double)0.1875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_NS;
                break;
            }
            case EAST: {
                returnShape = SHAPE_EW;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_NS;
                break;
            }
            case WEST: {
                returnShape = SHAPE_EW;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_NS;
                break;
            }
            case EAST: {
                returnShape = SHAPE_EW;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_NS;
                break;
            }
            case WEST: {
                returnShape = SHAPE_EW;
            }
        }
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        KatanaStandBlockEntity kse = (KatanaStandBlockEntity)world.getBlockEntity(pos);
        player.openMenu((MenuProvider)kse);
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = world.getBlockEntity(pos);
            if (tileentity instanceof KatanaStandBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((KatanaStandBlockEntity)tileentity));
                world.updateNeighborsAt(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof KatanaStandBlockEntity) {
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(DataComponents.CUSTOM_NAME, (Object)customName);
            ((KatanaStandBlockEntity)tileentity).setComponents(builder.build());
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KatanaStandBlockEntity(pos, state);
    }
}

