/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.VerticalRackBBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalRackB
extends RotatableBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_N_CENTER = VerticalRackB.makeShape_N_center();
    private static final VoxelShape SHAPE_E_CENTER = VerticalRackB.makeShape_E_center();
    private static final VoxelShape SHAPE_S_CENTER = VerticalRackB.makeShape_S_center();
    private static final VoxelShape SHAPE_W_CENTER = VerticalRackB.makeShape_W_center();
    private static final VoxelShape SHAPE_N_OFFSET = VerticalRackB.makeShape_N_offset();
    private static final VoxelShape SHAPE_E_OFFSET = VerticalRackB.makeShape_E_offset();
    private static final VoxelShape SHAPE_S_OFFSET = VerticalRackB.makeShape_S_offset();
    private static final VoxelShape SHAPE_W_OFFSET = VerticalRackB.makeShape_W_offset();
    public static final BooleanProperty CENTERED = BooleanProperty.create((String)"is_centered");

    public VerticalRackB(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static VoxelShape makeShape_N_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1625, (double)0.05815937500000001, (double)0.603925, (double)0.83125, (double)0.808159375, (double)0.666425), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.81875, (double)0.0, (double)0.55, (double)0.94375, (double)1.2875, (double)0.675), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.05625, (double)0.0, (double)0.55, (double)0.18125, (double)1.2875, (double)0.675), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.603925, (double)0.05815937500000001, (double)0.16874999999999996, (double)0.666425, (double)0.808159375, (double)0.8375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.55, (double)0.0, (double)0.05625000000000002, (double)0.675, (double)1.2875, (double)0.18125000000000002), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.55, (double)0.0, (double)0.81875, (double)0.675, (double)1.2875, (double)0.94375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.16874999999999996, (double)0.05815937500000001, (double)0.33357499999999995, (double)0.8375, (double)0.808159375, (double)0.39607499999999995), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.05625000000000002, (double)0.0, (double)0.32499999999999996, (double)0.18125000000000002, (double)1.2875, (double)0.44999999999999996), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.81875, (double)0.0, (double)0.32499999999999996, (double)0.94375, (double)1.2875, (double)0.44999999999999996), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.33357499999999995, (double)0.05815937500000001, (double)0.16249999999999998, (double)0.39607499999999995, (double)0.808159375, (double)0.83125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.32499999999999996, (double)0.0, (double)0.81875, (double)0.44999999999999996, (double)1.2875, (double)0.94375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.32499999999999996, (double)0.0, (double)0.05625000000000002, (double)0.44999999999999996, (double)1.2875, (double)0.18125000000000002), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_N_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1625, (double)0.05815937500000001, (double)0.916425, (double)0.83125, (double)0.808159375, (double)0.978925), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.81875, (double)0.0, (double)0.8625, (double)0.94375, (double)1.2875, (double)0.9875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.05625, (double)0.0, (double)0.8625, (double)0.18125, (double)1.2875, (double)0.9875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.916425, (double)0.05815937500000001, (double)0.16874999999999996, (double)0.978925, (double)0.808159375, (double)0.8374999999999999), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8625, (double)0.0, (double)0.05624999999999991, (double)0.9875, (double)1.2875, (double)0.1812499999999999), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8625, (double)0.0, (double)0.8187500000000001, (double)0.9875, (double)1.2875, (double)0.9437500000000001), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.16874999999999996, (double)0.05815937500000001, (double)0.021074999999999955, (double)0.8374999999999999, (double)0.808159375, (double)0.08357499999999995), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.05624999999999991, (double)0.0, (double)0.012499999999999956, (double)0.1812499999999999, (double)1.2875, (double)0.13749999999999996), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8187500000000001, (double)0.0, (double)0.012499999999999956, (double)0.9437500000000001, (double)1.2875, (double)0.13749999999999996), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.021074999999999955, (double)0.05815937500000001, (double)0.1625000000000001, (double)0.08357499999999995, (double)0.808159375, (double)0.83125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.012499999999999956, (double)0.0, (double)0.8187500000000001, (double)0.13749999999999996, (double)1.2875, (double)0.9437500000000001), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.012499999999999956, (double)0.0, (double)0.05624999999999991, (double)0.13749999999999996, (double)1.2875, (double)0.1812499999999999), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_N_CENTER : SHAPE_N_OFFSET;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_E_CENTER : SHAPE_E_OFFSET;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_S_CENTER : SHAPE_S_OFFSET;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_W_CENTER : SHAPE_W_OFFSET;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_N_CENTER : SHAPE_N_OFFSET;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_E_CENTER : SHAPE_E_OFFSET;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_S_CENTER : SHAPE_S_OFFSET;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_W_CENTER : SHAPE_W_OFFSET;
            }
        }
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        VerticalRackBBlockEntity blockEntity;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide() && (blockEntity = (VerticalRackBBlockEntity)world.getBlockEntity(pos)) != null) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = world.getBlockEntity(pos);
            if (tileentity instanceof VerticalRackBBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((VerticalRackBBlockEntity)tileentity));
                world.updateNeighborsAt(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof VerticalRackBBlockEntity) {
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(DataComponents.CUSTOM_NAME, (Object)customName);
            ((VerticalRackBBlockEntity)tileentity).setComponents(builder.build());
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VerticalRackBBlockEntity(pos, state);
    }

    public static void swapPosition(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState newState = (BlockState)state.cycle((Property)CENTERED);
        if (!world.isClientSide()) {
            world.setBlock(pos, newState, 3);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{CENTERED});
    }
}

