/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.VerticalRackDBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalRackD
extends RotatableBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_N_CENTER = VerticalRackD.makeShape_N_center();
    private static final VoxelShape SHAPE_E_CENTER = VerticalRackD.makeShape_E_center();
    private static final VoxelShape SHAPE_S_CENTER = VerticalRackD.makeShape_S_center();
    private static final VoxelShape SHAPE_W_CENTER = VerticalRackD.makeShape_W_center();
    private static final VoxelShape SHAPE_N_OFFSET = VerticalRackD.makeShape_N_offset();
    private static final VoxelShape SHAPE_E_OFFSET = VerticalRackD.makeShape_E_offset();
    private static final VoxelShape SHAPE_S_OFFSET = VerticalRackD.makeShape_S_offset();
    private static final VoxelShape SHAPE_W_OFFSET = VerticalRackD.makeShape_W_offset();
    public static final BooleanProperty CENTERED = BooleanProperty.create((String)"is_centered");

    public VerticalRackD(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static VoxelShape makeShape_N_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.04375, (double)0.725, (double)0.66875, (double)0.95, (double)0.7875, (double)0.73125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.84375, (double)0.0, (double)0.55, (double)0.96875, (double)0.9125, (double)0.7375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0, (double)0.55, (double)0.15625, (double)0.9125, (double)0.7375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.26875000000000004, (double)0.725, (double)0.043749999999999956, (double)0.33125000000000004, (double)0.7875, (double)0.95), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.26249999999999996, (double)0.0, (double)0.84375, (double)0.44999999999999996, (double)0.9125, (double)0.96875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.26249999999999996, (double)0.0, (double)0.03125, (double)0.44999999999999996, (double)0.9125, (double)0.15625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.050000000000000044, (double)0.725, (double)0.26875000000000004, (double)0.95625, (double)0.7875, (double)0.33125000000000004), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0, (double)0.26249999999999996, (double)0.15625, (double)0.9125, (double)0.44999999999999996), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.84375, (double)0.0, (double)0.26249999999999996, (double)0.96875, (double)0.9125, (double)0.44999999999999996), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W_center() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.66875, (double)0.725, (double)0.050000000000000044, (double)0.73125, (double)0.7875, (double)0.95625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.55, (double)0.0, (double)0.03125, (double)0.7375, (double)0.9125, (double)0.15625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.55, (double)0.0, (double)0.84375, (double)0.7375, (double)0.9125, (double)0.96875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_N_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.04375, (double)0.725, (double)0.91875, (double)0.95, (double)0.7875, (double)0.98125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.84375, (double)0.0, (double)0.8, (double)0.96875, (double)0.9125, (double)0.9875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0, (double)0.8, (double)0.15625, (double)0.9125, (double)0.9875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.018750000000000044, (double)0.725, (double)0.043749999999999956, (double)0.08125000000000004, (double)0.7875, (double)0.95), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.012499999999999956, (double)0.0, (double)0.84375, (double)0.19999999999999996, (double)0.9125, (double)0.96875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.012499999999999956, (double)0.0, (double)0.03125, (double)0.19999999999999996, (double)0.9125, (double)0.15625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.050000000000000044, (double)0.725, (double)0.018750000000000044, (double)0.95625, (double)0.7875, (double)0.08125000000000004), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0, (double)0.012499999999999956, (double)0.15625, (double)0.9125, (double)0.19999999999999996), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.84375, (double)0.0, (double)0.012499999999999956, (double)0.96875, (double)0.9125, (double)0.19999999999999996), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W_offset() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.91875, (double)0.725, (double)0.050000000000000044, (double)0.98125, (double)0.7875, (double)0.95625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8, (double)0.0, (double)0.03125, (double)0.9875, (double)0.9125, (double)0.15625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8, (double)0.0, (double)0.84375, (double)0.9875, (double)0.9125, (double)0.96875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_N_CENTER : SHAPE_N_OFFSET;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_E_CENTER : SHAPE_E_OFFSET;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_S_CENTER : SHAPE_S_OFFSET;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_W_CENTER : SHAPE_W_OFFSET;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_N_CENTER : SHAPE_N_OFFSET;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_E_CENTER : SHAPE_E_OFFSET;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_S_CENTER : SHAPE_S_OFFSET;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)CENTERED) != false ? SHAPE_W_CENTER : SHAPE_W_OFFSET;
            }
        }
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        VerticalRackDBlockEntity blockEntity;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide() && (blockEntity = (VerticalRackDBlockEntity)world.getBlockEntity(pos)) != null) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = world.getBlockEntity(pos);
            if (tileentity instanceof VerticalRackDBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((VerticalRackDBlockEntity)tileentity));
                world.updateNeighborsAt(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof VerticalRackDBlockEntity) {
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(DataComponents.CUSTOM_NAME, (Object)customName);
            ((VerticalRackDBlockEntity)tileentity).setComponents(builder.build());
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VerticalRackDBlockEntity(pos, state);
    }

    public static void swapPosition(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState newState = (BlockState)state.cycle((Property)CENTERED);
        if (!world.isClientSide()) {
            world.setBlock(pos, newState, 3);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{CENTERED});
    }
}

