/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalWallHolder
extends RotatableBlock
implements EntityBlock {
    private static VoxelShape SHAPE_N = VerticalWallHolder.makeShape_N();
    private static VoxelShape SHAPE_E = VerticalWallHolder.makeShape_E();
    private static VoxelShape SHAPE_S = VerticalWallHolder.makeShape_S();
    private static VoxelShape SHAPE_W = VerticalWallHolder.makeShape_W();
    public static final BooleanProperty PLAQUE = BooleanProperty.create((String)"plaque");

    public VerticalWallHolder(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PLAQUE, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape_N() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.23749999999999916, (double)0.176875, (double)-0.034375000000000044, (double)0.7624999999999991, (double)0.84875, (double)0.09687500000000004), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9031249999999995, (double)0.176875, (double)0.2374999999999996, (double)1.0343749999999996, (double)0.84875, (double)0.7624999999999995), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.2375, (double)0.176875, (double)0.903125, (double)0.7625, (double)0.84875, (double)1.034375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.03437500000000049, (double)0.176875, (double)0.2375000000000005, (double)0.0968749999999996, (double)0.84875, (double)0.7625000000000004), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_N;
                break;
            }
            case EAST: {
                returnShape = SHAPE_E;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_S;
                break;
            }
            case WEST: {
                returnShape = SHAPE_W;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_N;
                break;
            }
            case EAST: {
                returnShape = SHAPE_E;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_S;
                break;
            }
            case WEST: {
                returnShape = SHAPE_W;
            }
        }
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        VerticalWallHolderBlockEntity blockEntity;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide() && (blockEntity = (VerticalWallHolderBlockEntity)world.getBlockEntity(pos)) != null) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional<BlockState> newState;
        if (!((Boolean)state.getValue((Property)PLAQUE)).booleanValue() && player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.GOLD_INGOT) && (newState = VerticalWallHolder.addPlaque(state, world, pos, player, hand, hit)).isPresent()) {
            world.setBlock(pos, newState.get(), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Optional<BlockState> addPlaque(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item;
        if (player.getAbilities().mayBuild && hand == InteractionHand.MAIN_HAND && (item = player.getItemInHand(InteractionHand.MAIN_HAND)).is(Items.GOLD_INGOT)) {
            if (!player.isCreative()) {
                item.shrink(1);
            }
            world.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.2f + 1.0f);
            state = (BlockState)state.setValue((Property)PLAQUE, (Comparable)Boolean.valueOf(true));
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.horizontal_wall_holder.1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.horizontal_wall_holder.2"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = world.getBlockEntity(pos);
            if (tileentity instanceof VerticalWallHolderBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((VerticalWallHolderBlockEntity)tileentity));
                world.updateNeighborsAt(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof VerticalWallHolderBlockEntity) {
            Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.set(DataComponents.CUSTOM_NAME, (Object)customName);
            ((VerticalWallHolderBlockEntity)tileentity).setComponents(builder.build());
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clicked = context.getClickedFace();
        if (clicked.getAxis().isHorizontal()) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clicked.getOpposite());
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos supportPos = pos.relative(facing);
        return world.getBlockState(supportPos).isFaceSturdy((BlockGetter)world, supportPos, facing.getOpposite());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VerticalWallHolderBlockEntity(pos, state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{PLAQUE});
    }
}

