/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.WorkbenchBlockEntity;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Workbench
extends RotatableBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_N_FIRST = Workbench.makeShape_N_First();
    private static final VoxelShape SHAPE_E_FIRST = Workbench.makeShape_E_First();
    private static final VoxelShape SHAPE_W_FIRST = Workbench.makeShape_W_First();
    private static final VoxelShape SHAPE_S_FIRST = Workbench.makeShape_S_First();
    private static final VoxelShape SHAPE_N_SECOND = Workbench.makeShape_N_Second();
    private static final VoxelShape SHAPE_E_SECOND = Workbench.makeShape_E_Second();
    private static final VoxelShape SHAPE_W_SECOND = Workbench.makeShape_W_Second();
    private static final VoxelShape SHAPE_S_SECOND = Workbench.makeShape_S_Second();
    public static final BooleanProperty SECOND = BooleanProperty.create((String)"second");

    public Workbench(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SECOND, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape_N_First() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.375, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.625, (double)0.375, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)0.1875, (double)1.0, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)0.6875, (double)1.0, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.375, (double)0.3125, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E_First() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.375, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.125, (double)0.375, (double)0.8125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.375, (double)0.3125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)0.1875, (double)0.625, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W_First() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.625, (double)0.375, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.625, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.0, (double)0.3125, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.125, (double)0.0, (double)0.8125, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)0.6875, (double)0.625, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_S_First() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.625, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.6875, (double)0.625, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.1875, (double)0.625, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.125, (double)0.375, (double)0.8125, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_N_Second() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.6875, (double)0.125, (double)0.375, (double)1.8125, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.0, (double)0.125, (double)0.1875, (double)1.625, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.0, (double)0.125, (double)0.6875, (double)1.625, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.625, (double)0.0, (double)0.125, (double)1.875, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.625, (double)0.0, (double)0.625, (double)1.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = shape.move(-1.0, 0.0, 0.0);
        return shape;
    }

    public static VoxelShape makeShape_E_Second() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)1.125, (double)2.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)1.6875, (double)0.625, (double)0.25, (double)1.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.125, (double)1.0, (double)0.8125, (double)0.25, (double)1.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)1.0, (double)0.3125, (double)0.25, (double)1.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)1.625, (double)0.875, (double)1.0, (double)1.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)1.625, (double)0.375, (double)1.0, (double)1.875), (BooleanOp)BooleanOp.OR);
        shape = shape.move(0.0, 0.0, -1.0);
        return shape;
    }

    public static VoxelShape makeShape_W_Second() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)-1.0, (double)1.0, (double)1.125, (double)0.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.125, (double)-0.8125, (double)0.625, (double)0.25, (double)-0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)-0.625, (double)0.3125, (double)0.25, (double)0.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.125, (double)-0.625, (double)0.8125, (double)0.25, (double)0.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)-0.875, (double)0.375, (double)1.0, (double)-0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)-0.875, (double)0.875, (double)1.0, (double)-0.625), (BooleanOp)BooleanOp.OR);
        shape = shape.move(0.0, 0.0, 1.0);
        return shape;
    }

    public static VoxelShape makeShape_S_Second() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)1.0, (double)0.0, (double)0.0, (double)1.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.8125, (double)0.125, (double)0.375, (double)-0.6875, (double)0.25, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.625, (double)0.125, (double)0.6875, (double)0.0, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.625, (double)0.125, (double)0.1875, (double)0.0, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.875, (double)0.0, (double)0.625, (double)-0.625, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.875, (double)0.0, (double)0.125, (double)-0.625, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = shape.move(1.0, 0.0, 0.0);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_N_SECOND : SHAPE_N_FIRST;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_E_SECOND : SHAPE_E_FIRST;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_S_SECOND : SHAPE_S_FIRST;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_W_SECOND : SHAPE_W_FIRST;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_N_SECOND : SHAPE_N_FIRST;
                break;
            }
            case EAST: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_E_SECOND : SHAPE_E_FIRST;
                break;
            }
            case SOUTH: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_S_SECOND : SHAPE_S_FIRST;
                break;
            }
            case WEST: {
                returnShape = (Boolean)state.getValue((Property)SECOND) != false ? SHAPE_W_SECOND : SHAPE_W_FIRST;
            }
        }
        return returnShape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        WorkbenchBlockEntity blockEntity;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide() && (blockEntity = (WorkbenchBlockEntity)world.getBlockEntity(pos)) != null) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WorkbenchBlockEntity(pos, state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction face;
        Direction widthDir;
        BlockPos pos;
        Level world = ctx.getLevel();
        if (!world.getBlockState((pos = ctx.getClickedPos()).relative(widthDir = (face = ctx.getHorizontalDirection().getOpposite()).getClockWise())).canBeReplaced(ctx)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face)).setValue((Property)SECOND, (Comparable)Boolean.valueOf(false));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        Direction widthDir = ((Direction)state.getValue((Property)FACING)).getClockWise();
        world.setBlock(pos.relative(widthDir), (BlockState)state.setValue((Property)SECOND, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.workbench.1"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockPos other;
            Direction widthDir = ((Direction)state.getValue((Property)FACING)).getClockWise();
            BlockPos blockPos = other = (Boolean)state.getValue((Property)SECOND) != false ? pos.relative(widthDir.getOpposite()) : pos.relative(widthDir);
            if (world.getBlockState(other).getBlock() == this) {
                world.destroyBlock(other, false);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{SECOND});
    }
}

