/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.chat;

import dev.architectury.event.events.common.PlayerEvent;
import io.github.fetzi.config.FetzisDisplaysConfig;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class FetzisDisplaysChat {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(FetzisDisplaysChat::onPlayerJoin);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        String firstJoinTag = "fetzisdisplays.firstjoin";
        Set tags = player.getTags();
        if (!tags.contains(firstJoinTag) && FetzisDisplaysConfig.getChatMessageOnce()) {
            player.addTag(firstJoinTag);
            FetzisDisplaysConfig.setChatMessageOnJoin(true);
        }
        if (FetzisDisplaysConfig.getChatMessageOnJoin()) {
            Style discordStyle = Style.EMPTY;
            discordStyle = discordStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/GSaW4rr5NB"));
            discordStyle = discordStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.fetzisdisplays.joinmessage_hover")));
            player.displayClientMessage((Component)Component.translatable((String)"chat.fetzisdisplays.joinmessage_part_1").append((Component)Component.literal((String)(player.getScoreboardName() + " ")).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.BLUE})), false);
            player.displayClientMessage((Component)Component.translatable((String)"chat.fetzisdisplays.joinmessage_part_2").withStyle(discordStyle), false);
            Style wikiStyle = Style.EMPTY;
            wikiStyle = wikiStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://fetzis-orga.gitbook.io/fetzis-displays"));
            wikiStyle = wikiStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.fetzisdisplays.joinmessage_hover_2")));
            wikiStyle = wikiStyle.withUnderlined(Boolean.valueOf(true));
            player.displayClientMessage((Component)Component.empty(), false);
            player.displayClientMessage((Component)Component.translatable((String)"chat.fetzisdisplays.joinmessage_part_4", (Object[])new Object[]{Component.translatable((String)"chat.fetzisdisplays.joinmessage_part_5").withStyle(wikiStyle)}), false);
            if (FetzisDisplaysConfig.getChatMessageOnce()) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.fetzisdisplays.joinmessage_part_3").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), false);
                FetzisDisplaysConfig.setChatMessageOnJoin(false);
            }
        }
    }
}

