/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.architectury.platform.Platform;
import io.github.fetzi.util.FetzisDisplaysOverlay;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FetzisDisplaysConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("fetzis_displays/fetzis-displays-config.json");
    private static ConfigData configData = new ConfigData();
    private static final String CURRENT_MOD_VERSION = "1.0.0";

    public static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (!CURRENT_MOD_VERSION.equals(FetzisDisplaysConfig.configData.modVersion)) {
                    System.out.println("[Fetzi's Displays] Config version mismatch. Updating config...");
                    FetzisDisplaysConfig.configData.modVersion = CURRENT_MOD_VERSION;
                    FetzisDisplaysConfig.saveConfig();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                System.err.println("[Fetzi's Displays] Failed to load config, using default settings.");
                e.printStackTrace();
                FetzisDisplaysConfig.saveConfig();
            }
        } else {
            FetzisDisplaysConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)configData, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[Fetzi's Displays] Failed to save config.");
            e.printStackTrace();
        }
    }

    public static boolean getChatMessageOnJoin() {
        return FetzisDisplaysConfig.configData.chatMessageOnJoin;
    }

    public static void setChatMessageOnJoin(boolean value) {
        FetzisDisplaysConfig.configData.chatMessageOnJoin = value;
        FetzisDisplaysConfig.saveConfig();
    }

    public static boolean getChatMessageOnce() {
        return FetzisDisplaysConfig.configData.chatMessageOnce;
    }

    public static void setChatMessageOnce(boolean value) {
        FetzisDisplaysConfig.configData.chatMessageOnce = value;
        FetzisDisplaysConfig.saveConfig();
    }

    public static FetzisDisplaysOverlay.HudCorner getItemGUIPos() {
        return FetzisDisplaysConfig.configData.itemGUIPos;
    }

    public static void setItemGUIPos(FetzisDisplaysOverlay.HudCorner value) {
        FetzisDisplaysConfig.configData.itemGUIPos = value;
        FetzisDisplaysConfig.saveConfig();
    }

    private static class ConfigData {
        String modVersion = "1.0.0";
        String configWiki = "https://fetzis-orga.gitbook.io/fetzis-displays/config-settings";
        boolean chatMessageOnJoin = true;
        boolean chatMessageOnce = true;
        FetzisDisplaysOverlay.HudCorner itemGUIPos = FetzisDisplaysOverlay.HudCorner.BOTTOM_LEFT;

        private ConfigData() {
        }
    }
}

