/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import io.github.fetzi.util.FetzisDisplaysTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlassClocheBlockRenderer
implements BlockEntityRenderer<GlassClocheBlockEntity> {
    public GlassClocheBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(GlassClocheBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        if (defaultValues && !items.isEmpty()) {
            Item item = items.getItem();
            CompoundTag tag = new CompoundTag();
            if (item instanceof PlayerHeadItem || items.is(FetzisDisplaysTags.Items.HEADS)) {
                tag.putInt("Scale", 75);
                tag.putBoolean("defaultValues", false);
            }
            NetworkManager.sendToServer((CustomPacketPayload)new SyncBlockEntityDataPacket(blockEntity.getBlockPos(), tag));
        }
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)GlassCloche.FACING);
        Boolean isAnimated = (Boolean)blockEntity.getBlockState().getValue((Property)GlassCloche.ANIMATED);
        int xDegree = blockEntity.getXDegree();
        int zDegree = blockEntity.getZDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float x = 0.5f;
        float z = 0.5f;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                x = xz;
                break;
            }
            case EAST: 
            case WEST: {
                z = xz;
            }
        }
        if (!items.isEmpty()) {
            double seconds = (double)System.nanoTime() * 1.0E-9;
            poseStack.pushPose();
            if (items.getItem() instanceof PlayerHeadItem || items.is(FetzisDisplaysTags.Items.HEADS)) {
                Player playerNearby = blockEntity.getLevel().getNearestPlayer((double)blockEntity.getBlockPos().getX() + 0.5, (double)blockEntity.getBlockPos().getY() + 0.5, (double)blockEntity.getBlockPos().getZ() + 0.5, 3.0, false);
                if (playerNearby != null && isAnimated.booleanValue()) {
                    poseStack.translate(x, y, z);
                    double dx = playerNearby.getX() - ((double)blockEntity.getBlockPos().getX() + 0.5);
                    double dy = playerNearby.getY() + (double)playerNearby.getEyeHeight() - ((double)blockEntity.getBlockPos().getY() + 0.5);
                    double dz = playerNearby.getZ() - ((double)blockEntity.getBlockPos().getZ() + 0.5);
                    float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) + 90.0f;
                    double dist = Math.sqrt(dx * dx + dz * dz);
                    float pitch = (float)Math.toDegrees(Math.atan2(dy, dist));
                    poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
                    poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
                } else {
                    if (isAnimated.booleanValue()) {
                        float yOffset = 0.05f * (float)Math.sin(seconds * 2.0);
                        poseStack.translate(0.5f, y + yOffset, 0.5f);
                        float rotationAngle = (float)(seconds * 80.0 % 360.0);
                        poseStack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
                    } else {
                        poseStack.translate(x, y, z);
                        poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
                    }
                    poseStack.mulPose(Axis.ZP.rotationDegrees((float)zDegree));
                    poseStack.mulPose(Axis.XP.rotationDegrees((float)xDegree));
                }
                poseStack.scale(scale, scale, scale);
            } else {
                if (isAnimated.booleanValue()) {
                    float yOffset = 0.05f * (float)Math.sin(seconds * 2.0);
                    poseStack.translate(0.5f, y + yOffset, 0.5f);
                    float rotationAngle = (float)(seconds * 80.0 % 360.0);
                    poseStack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
                } else {
                    poseStack.translate(x, y, z);
                    poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
                }
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)zDegree));
                poseStack.mulPose(Axis.XP.rotationDegrees((float)xDegree));
                poseStack.scale(scale, scale, scale);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

