/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorizontalWallHolderRenderer
implements BlockEntityRenderer<HorizontalWallHolderBlockEntity> {
    public HorizontalWallHolderRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(HorizontalWallHolderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalWallHolder.FACING);
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        if (defaultValues && !items.isEmpty()) {
            Item item = items.getItem();
            CompoundTag tag = new CompoundTag();
            tag.putInt("yDegree", (int)(-dir.toYRot() + 180.0f));
            tag.putBoolean("defaultValues", false);
            NetworkManager.sendToServer((CustomPacketPayload)new SyncBlockEntityDataPacket(blockEntity.getBlockPos(), tag));
        }
        int zDegree = blockEntity.getZDegree();
        int xDegree = blockEntity.getXDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float xF = 0.0f;
        float yF = 0.0f;
        float zF = 0.0f;
        float nameXF = 0.0f;
        float nameYF = 0.0f;
        float nameZF = 0.0f;
        if (!items.isEmpty()) {
            poseStack.pushPose();
            switch (dir) {
                case NORTH: {
                    xF = xz;
                    yF = y;
                    zF = 0.08f;
                    break;
                }
                case EAST: {
                    xF = 0.92f;
                    yF = y;
                    zF = xz;
                    break;
                }
                case SOUTH: {
                    xF = xz;
                    yF = y;
                    zF = 0.92f;
                    break;
                }
                case WEST: {
                    xF = 0.08f;
                    yF = y;
                    zF = xz;
                }
            }
            poseStack.translate(xF, yF, zF);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)zDegree));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)xDegree));
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
        Boolean plaque = (Boolean)blockEntity.getBlockState().getValue((Property)HorizontalWallHolder.PLAQUE);
        if (Minecraft.getInstance().player != null && plaque.booleanValue() && !items.is(Items.AIR)) {
            String itemName = items.getHoverName().getString();
            poseStack.pushPose();
            switch (dir) {
                case NORTH: {
                    nameZF = 0.16f;
                    nameXF = 0.5f;
                    break;
                }
                case EAST: {
                    nameZF = 0.5f;
                    nameXF = 0.84f;
                    break;
                }
                case SOUTH: {
                    nameZF = 0.84f;
                    nameXF = 0.5f;
                    break;
                }
                case WEST: {
                    nameZF = 0.5f;
                    nameXF = 0.16f;
                }
            }
            nameYF = 0.49f;
            poseStack.translate(nameXF, nameYF, nameZF);
            poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
            poseStack.scale(-0.0025f, -0.0025f, 0.1f);
            String cutItemName = "";
            cutItemName = itemName.length() > 20 ? itemName.substring(0, 20) : itemName;
            int textWidth = Minecraft.getInstance().font.width(cutItemName);
            Minecraft.getInstance().font.drawInBatch(cutItemName, (float)(-textWidth) / 2.0f, 0.0f, 2366979, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }
}

