/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KatanaStandBlockRenderer
implements BlockEntityRenderer<KatanaStandBlockEntity> {
    public KatanaStandBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(KatanaStandBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)KatanaStand.FACING);
        if (defaultValues && !items.isEmpty()) {
            Item item = items.getItem();
            CompoundTag tag = new CompoundTag();
            tag.putInt("yDegree", (int)(-dir.toYRot() + 180.0f));
            tag.putBoolean("defaultValues", false);
            NetworkManager.sendToServer((CustomPacketPayload)new SyncBlockEntityDataPacket(blockEntity.getBlockPos(), tag));
        }
        int zDegree = blockEntity.getZDegree();
        int xDegree = blockEntity.getXDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float x = 0.5f;
        float z = 0.5f;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                x = xz;
                break;
            }
            case EAST: 
            case WEST: {
                z = xz;
            }
        }
        if (!items.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)zDegree));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)xDegree));
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

