/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.VerticalRackB;
import io.github.fetzi.entity.custom.VerticalRackBBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalRackBRenderer
implements BlockEntityRenderer<VerticalRackBBlockEntity> {
    public VerticalRackBRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(VerticalRackBBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)VerticalRackB.FACING);
        Boolean centered = (Boolean)blockEntity.getBlockState().getValue((Property)VerticalRackB.CENTERED);
        int size = blockEntity.getItemsForRender().size();
        for (int i = 0; i < size; ++i) {
            ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(i);
            float offset = 0.0f;
            float xF = 0.0f;
            float yF = 0.0f;
            float zF = 0.0f;
            if (items.isEmpty()) continue;
            poseStack.pushPose();
            if (items.getItem() instanceof BlockItem) {
                if (!centered.booleanValue()) {
                    offset = 0.31f;
                }
                switch (dir) {
                    case NORTH: {
                        xF = i <= 3 ? 0.275f + (float)i * 0.15f : 0.275f + (float)(size - i - 1) * 0.15f;
                        yF = 0.87f;
                        if (i <= 3) {
                            zF = 0.525f + offset;
                            break;
                        }
                        zF = 0.7f + offset;
                        break;
                    }
                    case EAST: {
                        xF = i <= 3 ? 0.3f - offset : 0.475f - offset;
                        yF = 0.87f;
                        if (i <= 3) {
                            zF = 0.725f - (float)i * 0.15f;
                            break;
                        }
                        zF = 0.725f - (float)(size - i - 1) * 0.15f;
                        break;
                    }
                    case SOUTH: {
                        xF = i <= 3 ? 0.725f - (float)i * 0.15f : 0.725f - (float)(size - i - 1) * 0.15f;
                        yF = 0.87f;
                        if (i <= 3) {
                            zF = 0.3f - offset;
                            break;
                        }
                        zF = 0.475f - offset;
                        break;
                    }
                    case WEST: {
                        xF = i <= 3 ? 0.525f + offset : 0.7f + offset;
                        yF = 0.87f;
                        zF = i <= 3 ? 0.275f + (float)i * 0.15f : 0.275f + (float)(size - i - 1) * 0.15f;
                    }
                }
            } else {
                if (!centered.booleanValue()) {
                    offset = 0.31f;
                }
                switch (dir) {
                    case NORTH: {
                        xF = i <= 2 ? 0.72f : (i <= 5 ? 0.5f : 0.28f);
                        yF = 0.77f;
                        if (i + 1 == 3 || i + 1 == 6 || i + 1 == 9) {
                            zF = 0.5f + offset;
                            break;
                        }
                        if (i + 1 == 2 || i + 1 == 5 || i + 1 == 8) {
                            zF = 0.54f + offset;
                            break;
                        }
                        if (i + 1 != 1 && i + 1 != 4 && i + 1 != 7) break;
                        zF = 0.58f + offset;
                        break;
                    }
                    case EAST: {
                        if (i + 1 == 3 || i + 1 == 6 || i + 1 == 9) {
                            xF = 0.5f - offset;
                        } else if (i + 1 == 2 || i + 1 == 5 || i + 1 == 8) {
                            xF = 0.45999998f - offset;
                        } else if (i + 1 == 1 || i + 1 == 4 || i + 1 == 7) {
                            xF = 0.42000002f - offset;
                        }
                        yF = 0.77f;
                        if (i <= 2) {
                            zF = 0.27999997f;
                            break;
                        }
                        if (i <= 5) {
                            zF = 0.5f;
                            break;
                        }
                        zF = 0.72f;
                        break;
                    }
                    case SOUTH: {
                        xF = i <= 2 ? 0.27999997f : (i <= 5 ? 0.5f : 0.72f);
                        yF = 0.77f;
                        if (i + 1 == 3 || i + 1 == 6 || i + 1 == 9) {
                            zF = 0.5f - offset;
                            break;
                        }
                        if (i + 1 == 2 || i + 1 == 5 || i + 1 == 8) {
                            zF = 0.45999998f - offset;
                            break;
                        }
                        if (i + 1 != 1 && i + 1 != 4 && i + 1 != 7) break;
                        zF = 0.42000002f - offset;
                        break;
                    }
                    case WEST: {
                        if (i + 1 == 3 || i + 1 == 6 || i + 1 == 9) {
                            xF = 0.5f + offset;
                        } else if (i + 1 == 2 || i + 1 == 5 || i + 1 == 8) {
                            xF = 0.54f + offset;
                        } else if (i + 1 == 1 || i + 1 == 4 || i + 1 == 7) {
                            xF = 0.58f + offset;
                        }
                        yF = 0.77f;
                        zF = i <= 2 ? 0.72f : (i <= 5 ? 0.5f : 0.28f);
                    }
                }
            }
            poseStack.translate(xF, yF, zF);
            if (items.getItem() instanceof BlockItem) {
                poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot() + 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
            }
            if (items.getItem() instanceof BlockItem) {
                poseStack.scale(0.25f, 0.25f, 0.25f);
            } else {
                poseStack.scale(0.5f, 0.5f, 0.5f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

