/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.VerticalRackD;
import io.github.fetzi.entity.custom.VerticalRackDBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalRackDRenderer
implements BlockEntityRenderer<VerticalRackDBlockEntity> {
    public VerticalRackDRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(VerticalRackDBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)VerticalRackD.FACING);
        Boolean centered = (Boolean)blockEntity.getBlockState().getValue((Property)VerticalRackD.CENTERED);
        int size = blockEntity.getItemsForRender().size();
        for (int i = 0; i < size; ++i) {
            ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(i);
            float offset = 0.0f;
            float xF = 0.0f;
            float yF = 0.0f;
            float zF = 0.0f;
            if (items.isEmpty()) continue;
            poseStack.pushPose();
            if (items.getItem() instanceof BlockItem) {
                if (!centered.booleanValue()) {
                    offset = 0.25f;
                }
                switch (dir) {
                    case NORTH: {
                        xF = i <= 3 ? 0.275f + (float)i * 0.15f : 0.275f + (float)(size - i - 1) * 0.15f;
                        yF = 0.84f;
                        if (i <= 3) {
                            zF = 0.525f + offset;
                            break;
                        }
                        zF = 0.7f + offset;
                        break;
                    }
                    case EAST: {
                        xF = i <= 3 ? 0.3f - offset : 0.475f - offset;
                        yF = 0.84f;
                        if (i <= 3) {
                            zF = 0.725f - (float)i * 0.15f;
                            break;
                        }
                        zF = 0.725f - (float)(size - i - 1) * 0.15f;
                        break;
                    }
                    case SOUTH: {
                        xF = i <= 3 ? 0.725f - (float)i * 0.15f : 0.725f - (float)(size - i - 1) * 0.15f;
                        yF = 0.84f;
                        if (i <= 3) {
                            zF = 0.3f - offset;
                            break;
                        }
                        zF = 0.475f - offset;
                        break;
                    }
                    case WEST: {
                        xF = i <= 3 ? 0.525f + offset : 0.7f + offset;
                        yF = 0.84f;
                        zF = i <= 3 ? 0.275f + (float)i * 0.15f : 0.275f + (float)(size - i - 1) * 0.15f;
                    }
                }
            } else {
                if (!centered.booleanValue()) {
                    offset = 0.25f;
                }
                switch (dir) {
                    case NORTH: {
                        xF = i <= 3 ? 0.68f : 0.32f;
                        yF = 0.725f;
                        if (i <= 3) {
                            zF = 0.5f + offset + (float)i * 0.04f;
                            break;
                        }
                        zF = 0.5f + offset + (float)(size - i - 1) * 0.04f;
                        break;
                    }
                    case EAST: {
                        xF = i <= 3 ? 0.5f - offset - (float)i * 0.04f : 0.5f - offset - (float)(size - i - 1) * 0.04f;
                        yF = 0.725f;
                        if (i <= 3) {
                            zF = 0.32f;
                            break;
                        }
                        zF = 0.68f;
                        break;
                    }
                    case SOUTH: {
                        xF = i <= 3 ? 0.32f : 0.68f;
                        yF = 0.725f;
                        if (i <= 3) {
                            zF = 0.5f - offset - (float)i * 0.04f;
                            break;
                        }
                        zF = 0.5f - offset - (float)(size - i - 1) * 0.04f;
                        break;
                    }
                    case WEST: {
                        xF = i <= 3 ? 0.5f + offset + (float)i * 0.04f : 0.5f + offset + (float)(size - i - 1) * 0.04f;
                        yF = 0.725f;
                        zF = i <= 3 ? 0.68f : 0.32f;
                    }
                }
            }
            poseStack.translate(xF, yF, zF);
            if (items.getItem() instanceof BlockItem) {
                poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
                poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot() + 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
            }
            if (items.getItem() instanceof BlockItem) {
                poseStack.scale(0.25f, 0.25f, 0.25f);
            } else {
                poseStack.scale(0.45f, 0.45f, 0.45f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

