/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import io.github.fetzi.util.FetzisDisplaysTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalWallHolderRenderer
implements BlockEntityRenderer<VerticalWallHolderBlockEntity> {
    public VerticalWallHolderRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(VerticalWallHolderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)VerticalWallHolder.FACING);
        if (defaultValues && !items.isEmpty()) {
            Item item = items.getItem();
            CompoundTag tag = new CompoundTag();
            if (item instanceof SwordItem) {
                tag.putInt("zDegree", 135);
                tag.putInt("xDegree", 0);
                tag.putInt("yDegree", (int)(-dir.toYRot() + 180.0f));
                tag.putInt("Scale", 58);
                tag.putInt("Y", 42);
                tag.putInt("XZ", 50);
                tag.putBoolean("defaultValues", false);
            } else if (item instanceof BlockItem) {
                tag.putInt("zDegree", 0);
                tag.putInt("xDegree", 0);
                tag.putInt("yDegree", (int)(-dir.toYRot()));
                tag.putInt("Scale", 68);
                tag.putInt("Y", 55);
                tag.putInt("XZ", 50);
                tag.putBoolean("defaultValues", false);
            } else {
                tag.putInt("zDegree", 45);
                tag.putInt("xDegree", 0);
                tag.putInt("yDegree", (int)(-dir.toYRot() + 180.0f));
                tag.putInt("Scale", 46);
                tag.putInt("Y", 55);
                tag.putInt("XZ", 50);
                tag.putBoolean("defaultValues", false);
            }
            NetworkManager.sendToServer((CustomPacketPayload)new SyncBlockEntityDataPacket(blockEntity.getBlockPos(), tag));
        }
        int zDegree = blockEntity.getZDegree();
        int xDegree = blockEntity.getXDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float xF = 0.0f;
        float yF = 0.0f;
        float zF = 0.0f;
        float nameXF = 0.0f;
        float nameYF = 0.0f;
        float nameZF = 0.0f;
        if (!items.isEmpty()) {
            poseStack.pushPose();
            if (items.getItem() instanceof SwordItem) {
                switch (dir) {
                    case NORTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.12f;
                        break;
                    }
                    case EAST: {
                        xF = 0.88f;
                        yF = y;
                        zF = xz;
                        break;
                    }
                    case SOUTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.88f;
                        break;
                    }
                    case WEST: {
                        xF = 0.12f;
                        yF = y;
                        zF = xz;
                    }
                }
            } else {
                switch (dir) {
                    case NORTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.12f;
                        break;
                    }
                    case EAST: {
                        xF = 0.88f;
                        yF = y;
                        zF = xz;
                        break;
                    }
                    case SOUTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.88f;
                        break;
                    }
                    case WEST: {
                        xF = 0.12f;
                        yF = y;
                        zF = xz;
                    }
                }
            }
            if (items.getItem() instanceof PlayerHeadItem || items.is(FetzisDisplaysTags.Items.HEADS)) {
                poseStack.translate(xF, yF - 0.1f, zF);
            } else {
                poseStack.translate(xF, yF, zF);
            }
            if (items.getItem() instanceof SwordItem) {
                poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
            } else if (items.getItem() instanceof BlockItem) {
                poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees((float)yDegree));
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)zDegree));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)xDegree));
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
        Boolean plaque = (Boolean)blockEntity.getBlockState().getValue((Property)VerticalWallHolder.PLAQUE);
        if (Minecraft.getInstance().player != null && plaque.booleanValue() && !items.is(Items.AIR)) {
            String itemName = items.getHoverName().getString();
            poseStack.pushPose();
            switch (dir) {
                case NORTH: {
                    nameZF = 0.1f;
                    nameXF = 0.5f;
                    break;
                }
                case EAST: {
                    nameZF = 0.5f;
                    nameXF = 0.9f;
                    break;
                }
                case SOUTH: {
                    nameZF = 0.9f;
                    nameXF = 0.5f;
                    break;
                }
                case WEST: {
                    nameZF = 0.5f;
                    nameXF = 0.1f;
                }
            }
            nameYF = 0.8125f;
            poseStack.translate(nameXF, nameYF, nameZF);
            poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
            poseStack.scale(-0.003f, -0.003f, 0.1f);
            String cutItemName = "";
            cutItemName = itemName.length() > 20 ? itemName.substring(0, 20) : itemName;
            int textWidth = Minecraft.getInstance().font.width(cutItemName);
            Minecraft.getInstance().font.drawInBatch(cutItemName, (float)(-textWidth) / 2.0f, 0.0f, 2366979, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }
}

