/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.Workbench;
import io.github.fetzi.entity.custom.WorkbenchBlockEntity;
import io.github.fetzi.init.blockInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WorkbenchBlockRenderer
implements BlockEntityRenderer<WorkbenchBlockEntity> {
    public WorkbenchBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WorkbenchBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack resultItems;
        ItemStack inputItems;
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)Workbench.FACING);
        float rotationY = 0.0f;
        float xF = 0.0f;
        float zF = 0.0f;
        float offset = 0.0f;
        if (((Boolean)state.getValue((Property)Workbench.SECOND)).booleanValue()) {
            offset = 1.0f;
        }
        if (!(inputItems = blockEntity.getInput()).isEmpty()) {
            poseStack.pushPose();
            switch (facing) {
                case NORTH: {
                    xF = 1.6f - offset;
                    zF = 0.5f;
                    break;
                }
                case SOUTH: {
                    xF = -0.6f + offset;
                    zF = 0.5f;
                    break;
                }
                case EAST: {
                    xF = 0.5f;
                    zF = 1.6f - offset;
                    break;
                }
                case WEST: {
                    xF = 0.5f;
                    zF = -0.6f + offset;
                }
            }
            poseStack.translate(xF, 1.25f, zF);
            poseStack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(inputItems, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
        if (!(resultItems = blockEntity.getResult()).isEmpty()) {
            poseStack.pushPose();
            switch (facing) {
                case NORTH: {
                    xF = 0.4f - offset;
                    zF = 0.5f;
                    break;
                }
                case SOUTH: {
                    xF = 0.6f + offset;
                    zF = 0.5f;
                    break;
                }
                case EAST: {
                    xF = 0.5f;
                    zF = 0.4f - offset;
                    break;
                }
                case WEST: {
                    xF = 0.5f;
                    zF = 0.6f + offset;
                }
            }
            poseStack.translate(xF, 1.25f, zF);
            poseStack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
            poseStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(resultItems, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
        if (((Boolean)blockEntity.getBlockState().getValue((Property)Workbench.SECOND)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        switch (facing) {
            case NORTH: {
                rotationY = 0.0f;
                xF = 0.5f;
                zF = 0.0f;
                break;
            }
            case SOUTH: {
                rotationY = 180.0f;
                xF = 0.5f;
                zF = 1.0f;
                break;
            }
            case EAST: {
                rotationY = 270.0f;
                xF = 1.0f;
                zF = 0.5f;
                break;
            }
            case WEST: {
                rotationY = 90.0f;
                xF = 0.0f;
                zF = 0.5f;
            }
        }
        poseStack.translate(xF, 1.065f, zF);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        double seconds = (double)System.nanoTime() * 1.0E-9;
        float bladeRot = (float)(seconds * 400.0 % 360.0);
        Axis bladeAxis = Axis.ZN;
        if (bladeAxis != null) {
            if (bladeAxis == Axis.ZP || bladeAxis == Axis.ZN) {
                poseStack.translate(0.5f, 0.0f, 0.0f);
                poseStack.mulPose(bladeAxis.rotationDegrees(bladeRot));
                poseStack.translate(-0.5f, 0.0f, 0.0f);
            } else {
                poseStack.translate(0.0f, 0.0f, 0.5f);
                poseStack.mulPose(bladeAxis.rotationDegrees(bladeRot));
                poseStack.translate(0.0f, 0.0f, -0.5f);
            }
        }
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(((Block)blockInit.WORKBENCH_SAW.get()).defaultBlockState(), poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

