/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.custom;

import io.github.fetzi.init.blockEntityInit;
import io.github.fetzi.menu.SingleItemMenu;
import io.github.fetzi.util.FetzisDisplaysUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HorizontalWallHolderBlockEntity
extends RandomizableContainerBlockEntity {
    public static final int SIZE = 1;
    private boolean defaultValues = true;
    private int zDegree = 45;
    private int xDegree = 0;
    private int yDegree = 0;
    private int scale = 50;
    private int y = 65;
    private int xz = 50;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public HorizontalWallHolderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.HORIZONTAL_WALL_ENTITY_TYPE.get(), pos, state);
    }

    public boolean getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(boolean value) {
        this.defaultValues = value;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getZDegree() {
        return this.zDegree;
    }

    public void setZDegree(int zDegree) {
        this.zDegree = Math.floorMod(zDegree, 360);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getXDegree() {
        return this.xDegree;
    }

    public void setXDegree(int xDegree) {
        this.xDegree = Math.floorMod(xDegree, 360);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getYDegree() {
        return this.yDegree;
    }

    public void setYDegree(int yDegree) {
        this.yDegree = Math.floorMod(yDegree, 360);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = Mth.clamp((int)scale, (int)0, (int)100);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getXZ() {
        return this.xz;
    }

    public void setXZ(int xz) {
        this.xz = xz;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.zDegree = tag.getInt("zDegree");
        this.xDegree = tag.getInt("xDegree");
        this.yDegree = tag.getInt("yDegree");
        this.scale = tag.getInt("Scale");
        this.y = tag.getInt("Y");
        this.xz = tag.getInt("XZ");
        this.defaultValues = tag.getBoolean("defaultValues");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("zDegree", this.zDegree);
        tag.putInt("xDegree", this.xDegree);
        tag.putInt("yDegree", this.yDegree);
        tag.putInt("Scale", this.scale);
        tag.putInt("Y", this.y);
        tag.putInt("XZ", this.xz);
        tag.putBoolean("defaultValues", this.defaultValues);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new SingleItemMenu(syncId, playerInventory, (Container)this);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> newInv) {
        this.inventory = newInv;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        FetzisDisplaysUtil.broadcastUpdate((BlockEntity)this, true);
    }

    public int getContainerSize() {
        return 1;
    }

    public final NonNullList<ItemStack> getItemsForRender() {
        return this.inventory;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

