/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.custom;

import io.github.fetzi.init.blockEntityInit;
import io.github.fetzi.menu.EightItemMenu;
import io.github.fetzi.util.FetzisDisplaysUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalRackABlockEntity
extends RandomizableContainerBlockEntity {
    public static final int SIZE = 8;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);

    public VerticalRackABlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.VERTICAL_RACK_A_ENTITY_TYPE.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new EightItemMenu(syncId, playerInventory, (Container)this);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> newInv) {
        this.inventory = newInv;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        FetzisDisplaysUtil.broadcastUpdate((BlockEntity)this, true);
    }

    public int getContainerSize() {
        return 8;
    }

    public final NonNullList<ItemStack> getItemsForRender() {
        return this.inventory;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

