/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.custom;

import io.github.fetzi.init.blockEntityInit;
import io.github.fetzi.menu.WorkbenchMenu;
import io.github.fetzi.recipe.WorkbenchRecipe;
import io.github.fetzi.recipe.WorkbenchRecipeType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WorkbenchBlockEntity
extends BlockEntity
implements MenuProvider {
    private ItemStack inputItem = ItemStack.EMPTY;
    private ItemStack resultItem = ItemStack.EMPTY;

    public WorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.WORKBENCH_ENTITY_TYPE.get(), pos, state);
    }

    public Optional<WorkbenchRecipe> getRecipe(Level lvl) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(this.inputItem);
        return lvl.getRecipeManager().getRecipeFor(WorkbenchRecipeType.INSTANCE, (RecipeInput)recipeInput, lvl).map(recipeHolder -> (WorkbenchRecipe)recipeHolder.value());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.fetzisdisplays.workbench");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
        return new WorkbenchMenu(id, playerInv, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public void setInput(ItemStack stack) {
        this.inputItem = stack;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ItemStack getInput() {
        return this.inputItem;
    }

    public void setResult(ItemStack stack) {
        this.resultItem = stack;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ItemStack getResult() {
        return this.resultItem;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.inputItem.isEmpty()) {
            tag.put("Input", (Tag)new CompoundTag());
        } else {
            tag.put("Input", this.inputItem.save(registries));
        }
        if (this.resultItem.isEmpty()) {
            tag.put("Result", (Tag)new CompoundTag());
        } else {
            tag.put("Result", this.resultItem.save(registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag resultTag;
        CompoundTag inputTag;
        super.loadAdditional(tag, registries);
        this.inputItem = tag.contains("Input") ? ((inputTag = tag.getCompound("Input")).isEmpty() ? ItemStack.EMPTY : ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)inputTag)) : ItemStack.EMPTY;
        this.resultItem = tag.contains("Result") ? ((resultTag = tag.getCompound("Result")).isEmpty() ? ItemStack.EMPTY : ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)resultTag)) : ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }
}

