/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.VerticalRackA;
import io.github.fetzi.blocks.VerticalRackB;
import io.github.fetzi.blocks.VerticalRackC;
import io.github.fetzi.blocks.VerticalRackD;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HammerItem
extends Item {
    public HammerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        BlockState state = ctx.getLevel().getBlockState(pos);
        if (player.isCrouching() && (state.getBlock() instanceof VerticalRackA || state.getBlock() instanceof VerticalRackB || state.getBlock() instanceof VerticalRackC || state.getBlock() instanceof VerticalRackD)) {
            world.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.2f + 1.0f);
            String block = state.getBlock().arch$registryName().toString();
            if (block.contains("vertical_rack_a")) {
                VerticalRackA.swapPosition(world, pos, state, player);
            } else if (block.contains("vertical_rack_b")) {
                VerticalRackB.swapPosition(world, pos, state, player);
            } else if (block.contains("vertical_rack_c")) {
                VerticalRackC.swapPosition(world, pos, state, player);
            } else if (block.contains("vertical_rack_d")) {
                VerticalRackD.swapPosition(world, pos, state, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof GlassCloche) {
            GlassCloche.swapCloche(world, pos, state, player);
            world.playSound(null, pos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.2f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.hammer.1"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }
}

