/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.SyncTagPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;

public class MagnifyingGlassItem
extends Item {
    public MagnifyingGlassItem(Item.Properties properties) {
        super(properties);
    }

    public static void firstUseCheck(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("first_use")) {
            tag.putBoolean("first_use", true);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                Minecraft.getInstance().player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        BlockState state = ctx.getLevel().getBlockState(pos);
        ItemStack magnifying_glass = ctx.getItemInHand();
        MagnifyingGlassItem.firstUseCheck(magnifying_glass);
        if (player.isCrouching() && state.getBlock() instanceof GlassCloche) {
            CompoundTag tag = ((CustomData)magnifying_glass.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int scale = tag.getInt("scroll_scale");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof GlassClocheBlockEntity) {
                GlassClocheBlockEntity cloche = (GlassClocheBlockEntity)be;
                cloche.setScale(scale);
                cloche.setChanged();
                world.playSound(null, pos, SoundEvents.SPYGLASS_USE, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof KatanaStand) {
            CompoundTag tag = ((CustomData)magnifying_glass.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int scale = tag.getInt("scroll_scale");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof KatanaStandBlockEntity) {
                KatanaStandBlockEntity kse = (KatanaStandBlockEntity)be;
                kse.setScale(scale);
                kse.setChanged();
                world.playSound(null, pos, SoundEvents.SPYGLASS_USE, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof HorizontalWallHolder) {
            CompoundTag tag = ((CustomData)magnifying_glass.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int scale = tag.getInt("scroll_scale");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof HorizontalWallHolderBlockEntity) {
                HorizontalWallHolderBlockEntity hwhe = (HorizontalWallHolderBlockEntity)be;
                hwhe.setScale(scale);
                hwhe.setChanged();
                world.playSound(null, pos, SoundEvents.SPYGLASS_USE, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof VerticalWallHolder) {
            CompoundTag tag = ((CustomData)magnifying_glass.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int scale = tag.getInt("scroll_scale");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof VerticalWallHolderBlockEntity) {
                VerticalWallHolderBlockEntity vwhe = (VerticalWallHolderBlockEntity)be;
                vwhe.setScale(scale);
                vwhe.setChanged();
                world.playSound(null, pos, SoundEvents.SPYGLASS_USE, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.magnifying_glass.2"));
            tooltip.add((Component)Component.empty());
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("scroll_scale")) {
                int scale = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_scale");
                tooltip.add((Component)Component.translatable((String)"tooltip.magnifying_glass.1", (Object[])new Object[]{scale}));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public static void adjustScrollScale(ItemStack stack, int delta) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int current = tag.getInt("scroll_scale");
        int next = current + delta;
        next = Math.max(0, Math.min(100, next));
        tag.putInt("scroll_scale", next);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }
}

