/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.SyncTagPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;

public class ProtractorItem
extends Item {
    public ProtractorItem(Item.Properties properties) {
        super(properties);
    }

    public static void firstUseCheck(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("first_use")) {
            tag.putBoolean("first_use", true);
            if (!tag.contains("scroll_mode")) {
                tag.putString("scroll_mode", "zAxis");
            }
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                Minecraft.getInstance().player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        BlockState state = ctx.getLevel().getBlockState(pos);
        ItemStack protractor = ctx.getItemInHand();
        ProtractorItem.firstUseCheck(protractor);
        if (player.isCrouching() && state.getBlock() instanceof GlassCloche) {
            CompoundTag tag = ((CustomData)protractor.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int degree = tag.getInt("scroll_angle");
            String mode = tag.getString("scroll_mode");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof GlassClocheBlockEntity) {
                GlassClocheBlockEntity cloche = (GlassClocheBlockEntity)be;
                if (mode.equals("zAxis")) {
                    cloche.setZDegree(degree);
                    cloche.setChanged();
                } else if (mode.equals("xAxis")) {
                    cloche.setXDegree(degree);
                    cloche.setChanged();
                } else if (mode.equals("yAxis")) {
                    cloche.setYDegree(degree);
                    cloche.setChanged();
                }
                world.playSound(null, pos, SoundEvents.ANVIL_HIT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof KatanaStand) {
            CompoundTag tag = ((CustomData)protractor.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int degree = tag.getInt("scroll_angle");
            String mode = tag.getString("scroll_mode");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof KatanaStandBlockEntity) {
                KatanaStandBlockEntity kse = (KatanaStandBlockEntity)be;
                if (mode.equals("zAxis")) {
                    kse.setZDegree(degree);
                    kse.setChanged();
                } else if (mode.equals("xAxis")) {
                    kse.setXDegree(degree);
                    kse.setChanged();
                } else if (mode.equals("yAxis")) {
                    kse.setYDegree(degree);
                    kse.setChanged();
                }
                world.playSound(null, pos, SoundEvents.ANVIL_HIT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof HorizontalWallHolder) {
            CompoundTag tag = ((CustomData)protractor.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int degree = tag.getInt("scroll_angle");
            String mode = tag.getString("scroll_mode");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof HorizontalWallHolderBlockEntity) {
                HorizontalWallHolderBlockEntity hwhe = (HorizontalWallHolderBlockEntity)be;
                if (mode.equals("zAxis")) {
                    hwhe.setZDegree(degree);
                    hwhe.setChanged();
                } else if (mode.equals("xAxis")) {
                    hwhe.setXDegree(degree);
                    hwhe.setChanged();
                } else if (mode.equals("yAxis")) {
                    hwhe.setYDegree(degree);
                    hwhe.setChanged();
                }
                world.playSound(null, pos, SoundEvents.ANVIL_HIT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof VerticalWallHolder) {
            CompoundTag tag = ((CustomData)protractor.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int degree = tag.getInt("scroll_angle");
            String mode = tag.getString("scroll_mode");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof VerticalWallHolderBlockEntity) {
                VerticalWallHolderBlockEntity vwhe = (VerticalWallHolderBlockEntity)be;
                if (mode.equals("zAxis")) {
                    vwhe.setZDegree(degree);
                    vwhe.setChanged();
                } else if (mode.equals("xAxis")) {
                    vwhe.setXDegree(degree);
                    vwhe.setChanged();
                } else if (mode.equals("yAxis")) {
                    vwhe.setYDegree(degree);
                    vwhe.setChanged();
                }
                world.playSound(null, pos, SoundEvents.ANVIL_HIT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.protractor.2"));
            tooltip.add((Component)Component.empty());
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("scroll_mode")) {
                String mode = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("scroll_mode");
                if (mode.equals("zAxis")) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.zAxis")}));
                } else if (mode.equals("xAxis")) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.xAxis")}));
                } else if (mode.equals("yAxis")) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.yAxis")}));
                }
            }
            if (tag.contains("scroll_angle")) {
                int angle = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_angle");
                tooltip.add((Component)Component.translatable((String)"tooltip.protractor.1", (Object[])new Object[]{angle}));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public static void adjustScrollAngle(ItemStack stack, int delta) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int current = tag.getInt("scroll_angle");
        int next = (current + delta) % 360;
        if (next < 0) {
            next += 360;
        }
        tag.putInt("scroll_angle", next);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }
}

