/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.SyncTagPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;

public class RulerItem
extends Item {
    public RulerItem(Item.Properties properties) {
        super(properties);
    }

    public static void firstUseCheck(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("first_use")) {
            tag.putBoolean("first_use", true);
            if (!tag.contains("scroll_mode")) {
                tag.putString("scroll_mode", "vertical");
            }
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                Minecraft.getInstance().player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        BlockState state = ctx.getLevel().getBlockState(pos);
        ItemStack ruler = ctx.getItemInHand();
        RulerItem.firstUseCheck(ruler);
        if (player.isCrouching() && state.getBlock() instanceof GlassCloche) {
            CompoundTag tag = ((CustomData)ruler.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int y = tag.getInt("scroll_y");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof GlassClocheBlockEntity) {
                GlassClocheBlockEntity cloche = (GlassClocheBlockEntity)be;
                cloche.setY(y);
                cloche.setChanged();
                world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof KatanaStand) {
            CompoundTag tag = ((CustomData)ruler.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int xz = tag.getInt("scroll_xz");
            int y = tag.getInt("scroll_y");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof KatanaStandBlockEntity) {
                KatanaStandBlockEntity kse = (KatanaStandBlockEntity)be;
                kse.setY(y);
                kse.setXZ(xz);
                kse.setChanged();
                world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof HorizontalWallHolder) {
            CompoundTag tag = ((CustomData)ruler.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int xz = tag.getInt("scroll_xz");
            int y = tag.getInt("scroll_y");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof HorizontalWallHolderBlockEntity) {
                HorizontalWallHolderBlockEntity hwhe = (HorizontalWallHolderBlockEntity)be;
                hwhe.setY(y);
                hwhe.setXZ(xz);
                hwhe.setChanged();
                world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && state.getBlock() instanceof VerticalWallHolder) {
            CompoundTag tag = ((CustomData)ruler.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            int xz = tag.getInt("scroll_xz");
            int y = tag.getInt("scroll_y");
            BlockEntity be = world.getBlockEntity(pos);
            if (!world.isClientSide && be instanceof VerticalWallHolderBlockEntity) {
                VerticalWallHolderBlockEntity vwhe = (VerticalWallHolderBlockEntity)be;
                vwhe.setY(y);
                vwhe.setXZ(xz);
                vwhe.setChanged();
                world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.ruler.3"));
            tooltip.add((Component)Component.empty());
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("scroll_mode")) {
                String mode = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("scroll_mode");
                if (mode.equals("horizontal")) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.ruler.hor")}));
                } else if (mode.equals("vertical")) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.ruler.ver")}));
                }
            }
            if (tag.contains("scroll_xz")) {
                int xz = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_xz");
                float xzFloat = (float)xz / 100.0f;
                tooltip.add((Component)Component.translatable((String)"tooltip.ruler.1", (Object[])new Object[]{Float.valueOf(xzFloat)}));
            }
            if (tag.contains("scroll_y")) {
                int y = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_y");
                float yFloat = (float)y / 100.0f;
                tooltip.add((Component)Component.translatable((String)"tooltip.ruler.2", (Object[])new Object[]{Float.valueOf(yFloat)}));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }
}

