/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.menu;

import io.github.fetzi.init.menuInit;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FiveItemMenu
extends AbstractContainerMenu {
    protected final Container inventory;

    public FiveItemMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5));
    }

    public FiveItemMenu(int syncId, Inventory playerInventory, Container inventory) {
        super((MenuType)menuInit.FIVE_STAND_MENU.get(), syncId);
        this.inventory = inventory;
        this.inventory.startOpen(playerInventory.player);
        for (int i = 0; i < 5; ++i) {
            this.addSlot(new Slot(inventory, i, 44 + i * 18, 20));
        }
        int xPos = 8;
        int yPos = 51;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
        }
    }

    public void removed(Player playerEntity) {
        super.removed(playerEntity);
        this.inventory.stopOpen(playerEntity);
    }

    public boolean stillValid(Player playerEntity) {
        return this.inventory.stillValid(playerEntity);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < this.inventory.getContainerSize() ? !this.moveItemStackTo(itemStack2, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }
}

