/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.menu;

import io.github.fetzi.init.menuInit;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SingleItemMenu
extends AbstractContainerMenu {
    protected final Container inventory;

    public SingleItemMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(1));
    }

    public SingleItemMenu(int syncId, Inventory playerInventory, Container inventory) {
        super((MenuType)menuInit.SINGLE_STAND_MENU.get(), syncId);
        this.inventory = inventory;
        this.inventory.startOpen(playerInventory.player);
        this.addSlot(new Slot(inventory, 0, 80, 20));
        int xPos = 8;
        int yPos = 51;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
        }
    }

    public void removed(Player playerEntity) {
        super.removed(playerEntity);
        this.inventory.stopOpen(playerEntity);
    }

    public boolean stillValid(Player playerEntity) {
        return this.inventory.stillValid(playerEntity);
    }

    public ItemStack quickMoveStack(Player playerEntity, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            stack = stackInSlot.copy();
            if (slotIndex < this.inventory.getContainerSize() ? !this.moveItemStackTo(stackInSlot, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }
}

