/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.menu;

import com.google.common.collect.Lists;
import io.github.fetzi.entity.custom.WorkbenchBlockEntity;
import io.github.fetzi.init.blockInit;
import io.github.fetzi.init.menuInit;
import io.github.fetzi.recipe.WorkbenchRecipe;
import io.github.fetzi.recipe.WorkbenchRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorkbenchMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_START = 2;
    private static final int INV_END = 29;
    private static final int HOTBAR_START = 29;
    private static final int HOTBAR_END = 38;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    private List<RecipeHolder<WorkbenchRecipe>> recipes = Lists.newArrayList();
    private ItemStack lastInput = ItemStack.EMPTY;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private final Container container;
    private final ResultContainer resultContainer = new ResultContainer();
    private long lastSoundTime;
    private Runnable slotUpdateListener = () -> {};

    public WorkbenchMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.NULL);
    }

    public WorkbenchMenu(int id, Inventory playerInv, final ContainerLevelAccess access) {
        super((MenuType)menuInit.WORKBENCH_MENU.get(), id);
        this.access = access;
        this.level = playerInv.player.level();
        this.container = new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                WorkbenchMenu.this.slotsChanged((Container)this);
                WorkbenchMenu.this.slotUpdateListener.run();
            }
        };
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                WorkbenchMenu.this.resultContainer.awardUsedRecipes(player, List.of(WorkbenchMenu.this.inputSlot.getItem()));
                RecipeHolder<WorkbenchRecipe> recipeHolder = WorkbenchMenu.this.recipes.get(WorkbenchMenu.this.selectedRecipeIndex.get());
                WorkbenchRecipe recipe = (WorkbenchRecipe)recipeHolder.value();
                WorkbenchMenu.this.inputSlot.remove(recipe.getAmount());
                if (WorkbenchMenu.this.inputSlot.hasItem()) {
                    this.refreshResult();
                }
                access.execute((lvl, pos) -> {
                    long now = lvl.getGameTime();
                    if (WorkbenchMenu.this.lastSoundTime != now) {
                        lvl.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WorkbenchMenu.this.lastSoundTime = now;
                    }
                });
                access.execute((lvl, pos) -> {
                    BlockEntity be = lvl.getBlockEntity(pos);
                    if (be instanceof WorkbenchBlockEntity) {
                        WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                        wb.setInput(WorkbenchMenu.this.inputSlot.getItem());
                        wb.setResult(WorkbenchMenu.this.resultContainer.getItem(1));
                    }
                });
                super.onTake(player, stack);
            }

            private void refreshResult() {
                WorkbenchMenu.this.setupResultSlot();
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int hot = 0; hot < 9; ++hot) {
            this.addSlot(new Slot((Container)playerInv, hot, 8 + hot * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public boolean stillValid(Player player) {
        return WorkbenchMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)blockInit.WORKBENCH.get()));
    }

    public boolean clickMenuButton(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.set(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.recipes.size();
    }

    public void slotsChanged(Container inv) {
        ItemStack in = this.inputSlot.getItem();
        if (!in.equals(this.lastInput)) {
            this.lastInput = in.copy();
            this.recalcRecipes(inv, in);
        }
        this.access.execute((lvl, pos) -> {
            BlockEntity be = lvl.getBlockEntity(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(this.inputSlot.getItem());
                wb.setResult(this.resultContainer.getItem(1));
            }
        });
    }

    private void recalcRecipes(Container inv, ItemStack in) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(in);
        List all = this.level.getRecipeManager().getRecipesFor(WorkbenchRecipeType.INSTANCE, (RecipeInput)recipeInput, this.level);
        int oldIndex = this.selectedRecipeIndex.get();
        ArrayList<RecipeHolder<WorkbenchRecipe>> filtered = new ArrayList<RecipeHolder<WorkbenchRecipe>>();
        for (RecipeHolder recipeHolder : all) {
            WorkbenchRecipe recipe = (WorkbenchRecipe)recipeHolder.value();
            if (in.getCount() < recipe.getAmount()) continue;
            filtered.add((RecipeHolder<WorkbenchRecipe>)recipeHolder);
        }
        this.recipes = filtered;
        if (filtered.isEmpty()) {
            this.selectedRecipeIndex.set(-1);
        } else if (oldIndex >= 0 && oldIndex < filtered.size()) {
            this.selectedRecipeIndex.set(oldIndex);
        } else {
            this.selectedRecipeIndex.set(Math.min(Math.max(oldIndex, 0), filtered.size() - 1));
        }
        this.setupResultSlot();
    }

    private void setupResultSlot() {
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<WorkbenchRecipe> recipeHolder = this.recipes.get(this.selectedRecipeIndex.get());
            WorkbenchRecipe recipe = (WorkbenchRecipe)recipeHolder.value();
            SingleRecipeInput recipeInput = new SingleRecipeInput(this.inputSlot.getItem());
            RegistryAccess registryAccess = this.level.registryAccess();
            ItemStack out = recipe.assemble(recipeInput, (HolderLookup.Provider)registryAccess);
            this.resultContainer.setRecipeUsed(recipeHolder);
            this.resultSlot.set(out);
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
        this.access.execute((lvl, pos) -> {
            BlockEntity be = lvl.getBlockEntity(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(this.inputSlot.getItem());
                wb.setResult(this.resultSlot.getItem());
            }
        });
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack originalStack = slot.getItem();
        ItemStack resultCopy = originalStack.copy();
        if (index == 1) {
            SingleRecipeInput recipeInput;
            ItemStack out;
            RecipeHolder<WorkbenchRecipe> recipeHolder = this.recipes.get(this.selectedRecipeIndex.get());
            WorkbenchRecipe recipe = (WorkbenchRecipe)recipeHolder.value();
            int needed = recipe.getAmount();
            while (this.inputSlot.getItem().getCount() >= needed && this.moveItemStackTo(out = recipe.assemble(recipeInput = new SingleRecipeInput(this.inputSlot.getItem()), (HolderLookup.Provider)this.level.registryAccess()), 2, 38, true)) {
                this.inputSlot.remove(needed);
                slot.onQuickCraft(out, resultCopy);
            }
        } else if (index == 0) {
            if (!this.moveItemStackTo(originalStack, 2, 38, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(originalStack, resultCopy);
        } else if (index >= 2) {
            boolean validForWorkbench;
            SingleRecipeInput testInput = new SingleRecipeInput(originalStack.copy());
            boolean bl = validForWorkbench = !this.level.getRecipeManager().getRecipesFor(WorkbenchRecipeType.INSTANCE, (RecipeInput)testInput, this.level).isEmpty();
            if (validForWorkbench ? !this.moveItemStackTo(originalStack, 0, 1, false) : (index < 29 ? !this.moveItemStackTo(originalStack, 29, 38, false) : !this.moveItemStackTo(originalStack, 2, 29, false))) {
                return ItemStack.EMPTY;
            }
        }
        if (originalStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        this.broadcastChanges();
        return resultCopy;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.container);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((lvl, pos) -> {
            BlockEntity be = lvl.getBlockEntity(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(ItemStack.EMPTY);
                wb.setResult(ItemStack.EMPTY);
            }
        });
    }

    public List<RecipeHolder<WorkbenchRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }
}

