/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.network;

import dev.architectury.networking.NetworkManager;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public record SyncBlockEntityDataPacket(BlockPos pos, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBlockEntityDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fetzisdisplays", (String)"sync_block_entity_data"));
    public static final StreamCodec<FriendlyByteBuf, SyncBlockEntityDataPacket> CODEC = StreamCodec.ofMember(SyncBlockEntityDataPacket::encode, SyncBlockEntityDataPacket::decode);

    private void encode(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.tag);
    }

    private static SyncBlockEntityDataPacket decode(FriendlyByteBuf buf) {
        return new SyncBlockEntityDataPacket(buf.readBlockPos(), buf.readNbt());
    }

    public static void handle(SyncBlockEntityDataPacket packet, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            BlockEntity be = player.level().getBlockEntity(packet.pos);
            if (be == null) {
                return;
            }
            CompoundTag tag = packet.tag;
            BlockEntity blockEntity = be;
            Objects.requireNonNull(blockEntity);
            BlockEntity selector0$temp = blockEntity;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KatanaStandBlockEntity.class, HorizontalWallHolderBlockEntity.class, VerticalWallHolderBlockEntity.class, GlassClocheBlockEntity.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    KatanaStandBlockEntity holder = (KatanaStandBlockEntity)selector0$temp;
                    if (tag.contains("yDegree")) {
                        holder.setYDegree(tag.getInt("yDegree"));
                    }
                    if (!tag.contains("defaultValues")) break;
                    holder.setDefaultValues(tag.getBoolean("defaultValues"));
                    break;
                }
                case 1: {
                    HorizontalWallHolderBlockEntity holder = (HorizontalWallHolderBlockEntity)selector0$temp;
                    if (tag.contains("yDegree")) {
                        holder.setYDegree(tag.getInt("yDegree"));
                    }
                    if (!tag.contains("defaultValues")) break;
                    holder.setDefaultValues(tag.getBoolean("defaultValues"));
                    break;
                }
                case 2: {
                    VerticalWallHolderBlockEntity holder = (VerticalWallHolderBlockEntity)selector0$temp;
                    if (tag.contains("zDegree")) {
                        holder.setZDegree(tag.getInt("zDegree"));
                    }
                    if (tag.contains("xDegree")) {
                        holder.setXDegree(tag.getInt("xDegree"));
                    }
                    if (tag.contains("yDegree")) {
                        holder.setYDegree(tag.getInt("yDegree"));
                    }
                    if (tag.contains("Scale")) {
                        holder.setScale(tag.getInt("Scale"));
                    }
                    if (tag.contains("Y")) {
                        holder.setY(tag.getInt("Y"));
                    }
                    if (tag.contains("XZ")) {
                        holder.setXZ(tag.getInt("XZ"));
                    }
                    if (!tag.contains("defaultValues")) break;
                    holder.setDefaultValues(tag.getBoolean("defaultValues"));
                    break;
                }
                case 3: {
                    GlassClocheBlockEntity holder = (GlassClocheBlockEntity)selector0$temp;
                    if (tag.contains("Scale")) {
                        holder.setScale(tag.getInt("Scale"));
                    }
                    if (!tag.contains("defaultValues")) break;
                    holder.setDefaultValues(tag.getBoolean("defaultValues"));
                    break;
                }
                default: {
                    return;
                }
            }
            be.setChanged();
            player.level().sendBlockUpdated(packet.pos, be.getBlockState(), be.getBlockState(), 3);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

