/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.network;

import dev.architectury.networking.NetworkManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public record SyncTagPacket(CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTagPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fetzisdisplays", (String)"sync_tag"));
    public static final StreamCodec<FriendlyByteBuf, SyncTagPacket> CODEC = StreamCodec.ofMember(SyncTagPacket::encode, SyncTagPacket::decode);

    private void encode(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    private static SyncTagPacket decode(FriendlyByteBuf buf) {
        return new SyncTagPacket(buf.readNbt());
    }

    public static void handle(SyncTagPacket packet, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ItemStack stack = player.getMainHandItem();
            if (!stack.isEmpty()) {
                CompoundTag existingTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                CompoundTag newValues = packet.tag;
                for (String key : newValues.getAllKeys()) {
                    existingTag.put(key, newValues.get(key));
                }
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)existingTag));
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

