/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.recipe;

import io.github.fetzi.recipe.WorkbenchRecipeSerializer;
import io.github.fetzi.recipe.WorkbenchRecipeType;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WorkbenchRecipe
implements Recipe<SingleRecipeInput> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int amount;
    private final ItemStack result;

    public WorkbenchRecipe(@Nullable ResourceLocation id, Ingredient ingredient, int amount, ItemStack result) {
        this.id = id;
        this.ingredient = ingredient;
        this.amount = amount;
        this.result = result;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        ItemStack in = input.item();
        return this.ingredient.test(in) && in.getCount() >= this.amount;
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getAmount() {
        return this.amount;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return WorkbenchRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return WorkbenchRecipeType.INSTANCE;
    }
}

