/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.screen;

import io.github.fetzi.menu.WorkbenchMenu;
import io.github.fetzi.recipe.WorkbenchRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchMenu> {
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/stonecutter.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WorkbenchScreen(WorkbenchMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        menu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
        ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
        int scrollY = (int)(41.0f * this.scrollOffs);
        ResourceLocation scrollerSprite = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(scrollerSprite, this.leftPos + 119, this.topPos + 15 + scrollY, 12, 15);
        int x = this.leftPos + 52;
        int y = this.topPos + 14;
        int end = this.startIndex + 12;
        this.renderButtons(guiGraphics, x, y, end, mouseX, mouseY);
        this.renderRecipes(guiGraphics, x, y, end);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            int x = this.leftPos + 52;
            int y = this.topPos + 14;
            int end = this.startIndex + 12;
            List<RecipeHolder<WorkbenchRecipe>> list = ((WorkbenchMenu)this.menu).getRecipes();
            for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.menu).getNumRecipes(); ++i) {
                int idx = i - this.startIndex;
                int px = x + idx % 4 * 16;
                int py = y + idx / 4 * 18 + 2;
                if (mouseX < px || mouseX >= px + 16 || mouseY < py || mouseY >= py + 18) continue;
                guiGraphics.renderTooltip(this.font, ((WorkbenchRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int end, int mouseX, int mouseY) {
        ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_selected");
        ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_highlighted");
        ResourceLocation RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe");
        for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.menu).getNumRecipes(); ++i) {
            int idx = i - this.startIndex;
            int px = x + idx % 4 * 16;
            int py = y + idx / 4 * 18 + 2;
            ResourceLocation spriteToUse = i == ((WorkbenchMenu)this.menu).getSelectedRecipeIndex() ? RECIPE_SELECTED_SPRITE : (mouseX >= px && mouseX < px + 16 && mouseY >= py && mouseY < py + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            guiGraphics.blitSprite(spriteToUse, px, py - 1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int end) {
        List<RecipeHolder<WorkbenchRecipe>> list = ((WorkbenchMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.menu).getNumRecipes(); ++i) {
            int idx = i - this.startIndex;
            int px = x + idx % 4 * 16;
            int py = y + idx / 4 * 18 + 2;
            guiGraphics.renderItem(((WorkbenchRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), px, py);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int x = this.leftPos + 52;
            int y = this.topPos + 14;
            int end = this.startIndex + 12;
            for (int i = this.startIndex; i < end; ++i) {
                int idx = i - this.startIndex;
                double dx = mouseX - (double)(x + idx % 4 * 16);
                double dy = mouseY - (double)(y + idx / 4 * 18);
                if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 16.0) || !(dy < 18.0) || !((WorkbenchMenu)this.menu).clickMenuButton((Player)this.minecraft.player, i)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((WorkbenchMenu)this.menu).containerId, i);
                return true;
            }
            int sx = this.leftPos + 119;
            int sy = this.topPos + 9;
            if (mouseX >= (double)sx && mouseX < (double)(sx + 12) && mouseY >= (double)sy && mouseY < (double)(sy + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int top = this.topPos + 14;
            int bottom = top + 54;
            this.scrollOffs = ((float)mouseY - (float)top - 7.5f) / (float)(bottom - top - 15);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = ((((WorkbenchMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3) * 4;
            this.startIndex = (int)(this.scrollOffs * (float)this.startIndex);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int rows = (((WorkbenchMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
            float delta = (float)scrollY / (float)rows;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - delta / (float)rows), (float)0.0f, (float)1.0f);
            this.startIndex = (int)(this.scrollOffs * (float)rows) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WorkbenchMenu)this.menu).getNumRecipes() > 12;
    }

    private void containerChanged() {
        this.displayRecipes = ((WorkbenchMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

