/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.util;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.items.ProtractorItem;
import io.github.fetzi.items.RulerItem;
import io.github.fetzi.network.SyncTagPacket;
import io.github.fetzi.util.FetzisDisplaysKeybinds;
import io.github.fetzi.util.FetzisDisplaysOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class FetzisDisplaysClientTickHandler {
    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (FetzisDisplaysKeybinds.SWITCH_ITEM_MODE.consumeClick()) {
                String newMode;
                String mode;
                CompoundTag tag;
                assert (Minecraft.getInstance().player != null);
                ItemStack stack = client.player.getMainHandItem();
                if (stack.getItem() instanceof RulerItem) {
                    tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    mode = tag.getString("scroll_mode");
                    newMode = mode.equals("vertical") ? "horizontal" : "vertical";
                    tag.putString("scroll_mode", newMode);
                    NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                }
                if (stack.getItem() instanceof ProtractorItem) {
                    tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    mode = tag.getString("scroll_mode");
                    newMode = "";
                    if (mode.equals("zAxis")) {
                        newMode = "xAxis";
                    } else if (mode.equals("xAxis")) {
                        newMode = "yAxis";
                    } else if (mode.equals("yAxis")) {
                        newMode = "zAxis";
                    }
                    tag.putString("scroll_mode", newMode);
                    NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                }
            }
            if (FetzisDisplaysKeybinds.SWITCH_GUI_POS.consumeClick()) {
                FetzisDisplaysOverlay.cycleHudCorner();
            }
        });
    }
}

