/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.util;

import dev.architectury.event.events.client.ClientGuiEvent;
import io.github.fetzi.config.FetzisDisplaysConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class FetzisDisplaysOverlay {
    private static final ResourceLocation PROTRACTOR_ICON = ResourceLocation.fromNamespaceAndPath((String)"fetzisdisplays", (String)"textures/item/protractor.png");
    private static final ResourceLocation MAGNIFYING_GLASS_ICON = ResourceLocation.fromNamespaceAndPath((String)"fetzisdisplays", (String)"textures/item/magnifying_glass.png");
    private static final ResourceLocation RULER_ICON = ResourceLocation.fromNamespaceAndPath((String)"fetzisdisplays", (String)"textures/item/ruler.png");

    public static void cycleHudCorner() {
        HudCorner next = HudCorner.values()[(FetzisDisplaysConfig.getItemGUIPos().ordinal() + 1) % HudCorner.values().length];
        FetzisDisplaysConfig.setItemGUIPos(next);
    }

    public static void register() {
        ClientGuiEvent.RENDER_HUD.register((graphics, tickDelta) -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack stack = mc.player.getMainHandItem();
            if (stack.isEmpty()) {
                return;
            }
            int screenWidth = mc.getWindow().getGuiScaledWidth();
            int screenHeight = mc.getWindow().getGuiScaledHeight();
            int iconSize = 16;
            int textOffsetX = 20;
            int baseX = 4;
            int baseY = 10;
            HudCorner currentHudCorner = FetzisDisplaysConfig.getItemGUIPos();
            switch (currentHudCorner.ordinal()) {
                case 1: {
                    baseX = screenWidth - iconSize - baseX;
                    textOffsetX = -iconSize - 68;
                    break;
                }
                case 2: {
                    baseY = screenHeight - iconSize - baseY;
                    break;
                }
                case 3: {
                    baseX = screenWidth - iconSize - baseX;
                    baseY = screenHeight - iconSize - baseY;
                    textOffsetX = -iconSize - 68;
                }
            }
            if (stack.getItem().getDescriptionId().contains("protractor")) {
                String mode;
                graphics.blit(PROTRACTOR_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                int angle = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_angle");
                if (currentHudCorner.equals((Object)HudCorner.TOP_RIGHT) || currentHudCorner.equals((Object)HudCorner.BOTTOM_RIGHT)) {
                    textOffsetX += 4;
                }
                if ((mode = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("scroll_mode")).equals("zAxis")) {
                    graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.zAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                } else if (mode.equals("xAxis")) {
                    graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.xAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                } else if (mode.equals("yAxis")) {
                    graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.protractor.yAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                }
                graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.protractor.1", (Object[])new Object[]{angle}), baseX + textOffsetX, baseY + 10, 0xFFFFFF, true);
            }
            if (stack.getItem().getDescriptionId().contains("magnifying_glass")) {
                graphics.blit(MAGNIFYING_GLASS_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                int scale = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("scroll_scale");
                if (currentHudCorner.equals((Object)HudCorner.TOP_RIGHT) || currentHudCorner.equals((Object)HudCorner.BOTTOM_RIGHT)) {
                    textOffsetX += 28;
                }
                graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.magnifying_glass.1", (Object[])new Object[]{scale}), baseX + textOffsetX, baseY + 4, 0xFFFFFF, true);
            }
            if (stack.getItem().getDescriptionId().contains("ruler")) {
                graphics.blit(RULER_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                float xzOff = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getFloat("scroll_xz");
                float yOff = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getFloat("scroll_y");
                String mode = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("scroll_mode");
                if (mode.equals("vertical")) {
                    graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.ruler.ver")}), baseX + textOffsetX, baseY - 6, 0xFFFFFF, true);
                } else if (mode.equals("horizontal")) {
                    graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.translatable((String)"tooltip.ruler.hor")}), baseX + textOffsetX, baseY - 6, 0xFFFFFF, true);
                }
                graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.ruler.1", (Object[])new Object[]{Float.valueOf(xzOff / 100.0f)}), baseX + textOffsetX, baseY + 4, 0xFFFFFF, true);
                graphics.drawString(mc.font, (Component)Component.translatable((String)"tooltip.ruler.2", (Object[])new Object[]{Float.valueOf(yOff / 100.0f)}), baseX + textOffsetX, baseY + 14, 0xFFFFFF, true);
            }
        });
    }

    public static enum HudCorner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

