/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.util;

import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import io.github.fetzi.items.MagnifyingGlassItem;
import io.github.fetzi.items.ProtractorItem;
import io.github.fetzi.items.RulerItem;
import io.github.fetzi.network.SyncTagPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class FetzisDisplaysScrollHandler {
    public static EventResult handleScrollEvent(double verticalScroll) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.isShiftKeyDown()) {
            ItemStack stack = mc.player.getMainHandItem();
            if (stack.getItem() instanceof ProtractorItem) {
                int delta = verticalScroll > 0.0 ? 5 : -5;
                ProtractorItem.adjustScrollAngle(stack, delta);
                CompoundTag updated = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(updated));
                ProtractorItem.firstUseCheck(stack);
                return EventResult.interruptTrue();
            }
            if (stack.getItem() instanceof MagnifyingGlassItem) {
                int delta = verticalScroll > 0.0 ? 1 : -1;
                MagnifyingGlassItem.adjustScrollScale(stack, delta);
                CompoundTag updated = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(updated));
                MagnifyingGlassItem.firstUseCheck(stack);
                return EventResult.interruptTrue();
            }
            if (stack.getItem() instanceof RulerItem) {
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                int delta = verticalScroll > 0.0 ? 1 : -1;
                String mode = tag.getString("scroll_mode");
                if ("vertical".equals(mode)) {
                    tag.putInt("scroll_y", tag.getInt("scroll_y") + delta);
                } else {
                    tag.putInt("scroll_xz", tag.getInt("scroll_xz") + delta);
                }
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                NetworkManager.sendToServer((CustomPacketPayload)new SyncTagPacket(tag.copy()));
                RulerItem.firstUseCheck(stack);
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }
}

