/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.factory;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import org.watermedia.videolan4j.binding.internal.libvlc_rd_description_t;
import org.watermedia.videolan4j.binding.internal.libvlc_renderer_discoverer_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.binding.lib.size_t;
import org.watermedia.videolan4j.factory.BaseApi;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.renderer.RendererDiscoverer;
import org.watermedia.videolan4j.player.renderer.RendererDiscovererDescription;

public final class RendererApi
extends BaseApi {
    RendererApi(MediaPlayerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RendererDiscovererDescription> discoverers() {
        PointerByReference ref = new PointerByReference();
        size_t size = LibVlc.libvlc_renderer_discoverer_list_get(this.libvlcInstance, ref);
        try {
            int count = size.intValue();
            ArrayList<RendererDiscovererDescription> result = new ArrayList<RendererDiscovererDescription>(count);
            if (count > 0) {
                Pointer[] pointers;
                for (Pointer pointer : pointers = ref.getValue().getPointerArray(0L, count)) {
                    libvlc_rd_description_t description = (libvlc_rd_description_t)Structure.newInstance(libvlc_rd_description_t.class, (Pointer)pointer);
                    description.read();
                    result.add(new RendererDiscovererDescription(description.psz_name, description.psz_longname));
                }
            }
            ArrayList<RendererDiscovererDescription> arrayList = result;
            return arrayList;
        }
        finally {
            LibVlc.libvlc_renderer_discoverer_list_release(ref.getValue(), size);
        }
    }

    public RendererDiscoverer discoverer(String name) {
        libvlc_renderer_discoverer_t discoverer = LibVlc.libvlc_renderer_discoverer_new(this.libvlcInstance, name);
        if (discoverer != null) {
            return new RendererDiscoverer(discoverer);
        }
        return null;
    }
}

