/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import java.util.List;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_media_stats_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.AudioTrackInfo;
import org.watermedia.videolan4j.media.BaseApi;
import org.watermedia.videolan4j.media.Media;
import org.watermedia.videolan4j.media.MediaStatistics;
import org.watermedia.videolan4j.media.MediaType;
import org.watermedia.videolan4j.media.TextTrackInfo;
import org.watermedia.videolan4j.media.TrackInfo;
import org.watermedia.videolan4j.media.TrackInformation;
import org.watermedia.videolan4j.media.TrackType;
import org.watermedia.videolan4j.media.VideoTrackInfo;
import org.watermedia.videolan4j.player.base.State;

public final class InfoApi
extends BaseApi {
    private final libvlc_media_stats_t statsInstance = new libvlc_media_stats_t();

    InfoApi(Media media) {
        super(media);
    }

    public String mrl() {
        return VideoLan4J.copyAndFreeNativeString(LibVlc.libvlc_media_get_mrl(this.mediaInstance));
    }

    public MediaType type() {
        return MediaType.mediaType(LibVlc.libvlc_media_get_type(this.mediaInstance));
    }

    public State state() {
        return State.state(LibVlc.libvlc_media_get_state(this.mediaInstance));
    }

    public long duration() {
        return LibVlc.libvlc_media_get_duration(this.mediaInstance);
    }

    public List<? extends TrackInfo> tracks(TrackType ... types) {
        return TrackInformation.getTrackInfo(this.mediaInstance, types);
    }

    public List<AudioTrackInfo> audioTracks() {
        return this.tracks(TrackType.AUDIO);
    }

    public List<VideoTrackInfo> videoTracks() {
        return this.tracks(TrackType.VIDEO);
    }

    public List<TextTrackInfo> textTracks() {
        return this.tracks(TrackType.TEXT);
    }

    public boolean statistics(MediaStatistics mediaStatistics) {
        if (LibVlc.libvlc_media_get_stats(this.mediaInstance, this.statsInstance) != 0) {
            mediaStatistics.apply(this.statsInstance);
            return true;
        }
        return false;
    }

    public MediaStatistics statistics() {
        if (LibVlc.libvlc_media_get_stats(this.mediaInstance, this.statsInstance) != 0) {
            MediaStatistics mediaStatistics = new MediaStatistics();
            mediaStatistics.apply(this.statsInstance);
            return mediaStatistics;
        }
        return null;
    }
}

