/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.player.base.BaseApi;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.base.WaitForSnapshot;
import org.watermedia.videolan4j.waiter.BeforeWaiterAbortedException;

public final class SnapshotApi
extends BaseApi {
    private String snapshotDirectoryName;

    SnapshotApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void setSnapshotDirectory(String snapshotDirectoryName) {
        this.snapshotDirectoryName = snapshotDirectoryName;
    }

    public boolean save() {
        return this.save(0, 0);
    }

    public boolean save(int width, int height) {
        File snapshotDirectory = new File(this.snapshotDirectoryName == null ? System.getProperty("user.home") : this.snapshotDirectoryName);
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        return this.save(snapshotFile, width, height);
    }

    public boolean save(File file) {
        return this.save(file, 0, 0);
    }

    public boolean save(File file, int width, int height) {
        File snapshotDirectory = file.getParentFile();
        if (snapshotDirectory == null) {
            snapshotDirectory = new File(".");
        }
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (snapshotDirectory.exists()) {
            return LibVlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), width, height) == 0;
        }
        throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
    }

    public BufferedImage get() {
        return this.get(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(int width, int height) {
        File file = null;
        try {
            file = File.createTempFile("vlcj-snapshot-", ".png");
            BufferedImage bufferedImage = ImageIO.read(new File((String)new WaitForSnapshot(this.mediaPlayer, file, width, height).await()));
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
        catch (BeforeWaiterAbortedException e) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

