/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.component;

import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.medialist.MediaList;
import org.watermedia.videolan4j.medialist.MediaListRef;
import org.watermedia.videolan4j.player.component.CallbackMediaListPlayerComponentBase;
import org.watermedia.videolan4j.player.component.InputEvents;
import org.watermedia.videolan4j.player.component.MediaPlayerSpecs;
import org.watermedia.videolan4j.player.component.callback.CallbackImagePainter;
import org.watermedia.videolan4j.player.embedded.fullscreen.FullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;
import org.watermedia.videolan4j.player.list.MediaListPlayer;

public class CallbackMediaListPlayerComponent
extends CallbackMediaListPlayerComponentBase {
    private final MediaListPlayer mediaListPlayer = this.mediaPlayerFactory().mediaPlayers().newMediaListPlayer();
    private final MediaList mediaList;

    public CallbackMediaListPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        super(mediaPlayerFactory, fullScreenStrategy, inputEvents, bufferFormatCallback, lockBuffers, imagePainter, cleanupCallback, renderCallback);
        this.mediaListPlayer.mediaPlayer().setMediaPlayer(this.mediaPlayer());
        this.mediaListPlayer.events().addMediaListPlayerEventListener(this);
        this.mediaList = this.mediaPlayerFactory().media().newMediaList();
        this.mediaList.events().addMediaListEventListener(this);
        this.applyMediaList();
        this.onAfterConstruct();
    }

    public CallbackMediaListPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, imagePainter, null, null, null);
    }

    public CallbackMediaListPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, null, renderCallback, bufferFormatCallback, cleanupCallback);
    }

    public CallbackMediaListPlayerComponent(MediaPlayerSpecs.CallbackMediaPlayerSpec spec) {
        this(spec.factory, spec.fullScreenStrategy, spec.inputEvents, spec.lockedBuffers, spec.imagePainter, spec.renderCallback, spec.bufferFormatCallback, spec.cleanupCallback);
    }

    public CallbackMediaListPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory(libvlcArgs), null, null, true, null);
    }

    public CallbackMediaListPlayerComponent() {
        this(null, null, null, true, null, null, null, null);
    }

    private void applyMediaList() {
        MediaListRef mediaListRef = this.mediaList.newMediaListRef();
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
    }

    public final MediaListPlayer mediaListPlayer() {
        return this.mediaListPlayer;
    }

    @Override
    protected final void onBeforeRelease() {
        this.mediaListPlayer.release();
        this.mediaList.release();
    }
}

