/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.tools;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.watermedia.videolan4j.VideoLan4J;

public class Tools {
    public static File getRealFile(Path path) {
        if (!Files.isSymbolicLink(path)) {
            return path.toFile();
        }
        try {
            File symLink = Files.readSymbolicLink(path).toFile();
            VideoLan4J.LOGGER.debug("Path '{}' is a {} symlink to '{}'", (Object)path.toString(), (Object)(symLink.isDirectory() ? "directory" : "file"), (Object)symLink.toPath());
            return symLink;
        }
        catch (Exception exception) {
            return path.toFile();
        }
    }

    public static <T> T[] concat(T[] array, T[] array2) {
        if (array2.length == 0) {
            return array;
        }
        if (array.length == 0) {
            return array2;
        }
        int length = array.length + array2.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        return result;
    }

    public static String readStringSafe(Path path) {
        try {
            return Files.readString(path);
        }
        catch (Exception e) {
            VideoLan4J.LOGGER.error("Failed to read file at '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    public static <T> T[] toArray(T ... array) {
        return array;
    }

    public static Pattern[] patterns(String ... patterns) {
        Pattern[] result = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            result[i] = Pattern.compile(patterns[i]);
        }
        return result;
    }
}

