/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.config.ConfigCoroUtil;
import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class CoroUtilPath {
    public static boolean tryMoveToEntityLivingLongDist(Mob entSource, Entity entityTo, double moveSpeedAmp) {
        return CoroUtilPath.tryMoveToXYZLongDist(entSource, entityTo.getX(), entityTo.getBoundingBox().minY, entityTo.getZ(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, double x, double y, double z, double moveSpeedAmp) {
        boolean success;
        block12: {
            Level world = ent.level();
            success = false;
            try {
                int tries;
                int gatherZ;
                int gatherY;
                double followDist;
                if (!ent.getNavigation().isDone()) break block12;
                double distToPlayer = Math.sqrt(ent.distanceToSqr(x, y, z));
                if (distToPlayer <= (followDist = ent.getAttribute(Attributes.FOLLOW_RANGE).getValue())) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z), moveSpeedAmp);
                    break block12;
                }
                double d = x + 0.5 - ent.getX();
                double d2 = z + 0.5 - ent.getZ();
                double d1 = y + 0.5 - (ent.getY() + (double)ent.getEyeHeight());
                double d3 = Mth.sqrt((float)((float)(d * d + d2 * d2)));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                Mob center = ent;
                Random rand = new Random();
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.getX() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.getY(), gatherZ = (int)Math.floor(center.getZ() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.isLoaded(pos)) {
                    return false;
                }
                BlockState state = world.getBlockState(pos);
                if (!CoroUtilBlock.isAir(state.getBlock())) {
                    int offset = -5;
                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(state.getBlock()) && state.isPathfindable(PathComputationType.LAND); ++tries) {
                        pos = new BlockPos(gatherX, gatherY += offset++, gatherZ);
                        state = world.getBlockState(pos);
                    }
                } else {
                    while (tries < 30 && (CoroUtilBlock.isAir(state.getBlock()) || !state.isPathfindable(PathComputationType.LAND))) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.getBlockState(pos);
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, gatherX, gatherY, gatherZ, moveSpeedAmp);
                } else {
                    if (!world.isLoaded(pos = new BlockPos(pos.getX(), world.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ()), pos.getZ()).below())) {
                        return false;
                    }
                    state = world.getBlockState(pos);
                    if (state.isPathfindable(PathComputationType.LAND)) {
                        success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, pos.getX(), pos.getY(), pos.getZ(), moveSpeedAmp);
                    }
                }
            }
            catch (Exception ex) {
                CULog.err("Exception trying to pathfind");
                if (!ConfigCoroUtil.useLoggingError) break block12;
                ex.printStackTrace();
            }
        }
        return success;
    }
}

