/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.backpack.BackpackState;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackShelfMenu;
import com.mrcrayfish.backpacked.inventory.container.UnlockableContainer;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageLootboundTakeItem;
import com.mrcrayfish.backpacked.network.message.MessageShelfPlaceAnimation;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.network.LevelLocation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends BlockEntity {
    public static final int SIZE = 1;
    public static final int TOTAL_ANIMATION_TICKS = 4;
    private final SimpleContainer container = new ShelfContainer(this);
    private int recallQueueCount;
    @Nullable
    private UUID recallOwner = null;
    private int recallIndex = -1;
    @Nullable
    private ShelfKey key;
    private boolean loadingItems;
    private int animation = -1;
    public int tickCount;

    public ShelfBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ShelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHELF.get(), pos, state);
    }

    public SimpleContainer getContainer() {
        return this.container;
    }

    public int getRecallQueueCount() {
        return this.recallQueueCount;
    }

    public void setRecallQueueCount(int queueCount) {
        if (this.recallQueueCount != queueCount) {
            this.recallQueueCount = queueCount;
            this.setChanged();
        }
    }

    public void recall(ItemStack stack, UUID owner, int originalIndex) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.setBackpack(stack.copyAndClear());
            this.recallOwner = owner;
            this.recallIndex = originalIndex;
            Vec3 center = this.getBlockState().getShape((BlockGetter)this.level, this.worldPosition).bounds().getCenter().add(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
            level2.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, center.x, center.y, center.z, 20, 0.25, 0.25, 0.25, 0.1);
            float pitch = 0.7f + 0.1f * level2.random.nextFloat();
            level2.playSound(null, center.x, center.y, center.z, SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    public ShelfKey key() {
        Preconditions.checkNotNull((Object)this.level);
        if (this.key == null) {
            this.key = new ShelfKey((ResourceKey<Level>)this.level.dimension(), this.worldPosition.asLong());
        }
        return this.key;
    }

    public void popBackpack(Player player) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack backpack = this.getBackpack();
        if (backpack.isEmpty()) {
            return;
        }
        Vec3 pos = this.worldPosition.getCenter().subtract(0.0, 0.25, 0.0);
        UUID originalOwner = this.recallOwner;
        int originalIndex = this.recallIndex;
        this.setBackpack(ItemStack.EMPTY);
        if (player.getUUID().equals(originalOwner) && originalIndex != -1 && BackpackHelper.getBackpackStack(player, originalIndex).isEmpty() && BackpackHelper.setBackpackStack(player, backpack.copy(), originalIndex)) {
            Network.getPlay().sendToTrackingLocation(() -> LevelLocation.create((ServerLevel)serverLevel, (BlockPos)this.worldPosition, (double)16.0), (Object)new MessageLootboundTakeItem(player.getId(), new ItemStack((ItemLike)backpack.getItem()), pos, false));
            serverLevel.playSeededSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), player.getSoundSource(), 1.0f, 1.0f, player.getRandom().nextLong());
            return;
        }
        ItemEntity entity = new ItemEntity((Level)serverLevel, pos.x, pos.y - 0.25, pos.z, backpack.copyAndClear());
        if (serverLevel.addFreshEntity((Entity)entity)) {
            entity.playerTouch(player);
        }
    }

    private void openBackpackInventory(ServerPlayer player) {
    }

    public void openShelfManagement(ServerPlayer player) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((Player)player);
        FrameworkAPI.openMenuWithData((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new BackpackShelfMenu(windowId, playerInventory, new ManagementInventory(player), (Container)this.container, slots), (Component)Component.translatable((String)"container.backpack_shelf")), (IMenuData)new ManagementContainerData(slots, false));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        CompoundTag containerTag = tag.getCompound("Container");
        this.loadingItems = true;
        ContainerHelper.loadAllItems((CompoundTag)containerTag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)provider);
        this.loadingItems = false;
        ItemStack backpack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Backpack"));
        if (tag.contains("Items", 10)) {
            BackpackShelfContainer container1;
            BackpackShelfContainer backpackShelfContainer = container1 = backpack.isEmpty() ? null : new BackpackShelfContainer(this, this.getBackpackSize());
            if (container1 != null) {
                container1.load(tag, provider);
                backpack.set(DataComponents.CONTAINER, (Object)container1.createContents());
            }
        }
        this.container.setItem(0, backpack);
        this.recallQueueCount = tag.getInt("QueueCount");
        if (tag.hasUUID("RecallOwner")) {
            this.recallOwner = tag.getUUID("RecallOwner");
            if (tag.contains("RecallIndex", 3)) {
                this.recallIndex = tag.getInt("RecallIndex");
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag containerTag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)containerTag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)provider);
        tag.put("Container", (Tag)containerTag);
        tag.put("Backpack", this.container.getItem(0).saveOptional(provider));
        if (this.recallOwner != null) {
            tag.putUUID("RecallOwner", this.recallOwner);
            if (this.recallIndex > 0) {
                tag.putInt("RecallIndex", this.recallIndex);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put("Backpack", this.container.getItem(0).saveOptional(provider));
        tag.putInt("QueueCount", this.recallQueueCount);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStack getBackpack() {
        return this.container.getItem(0);
    }

    public void setBackpack(ItemStack stack) {
        this.container.setItem(0, stack);
        this.recallOwner = null;
        this.recallIndex = -1;
        this.setChanged();
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ShelfBlock.FACING);
    }

    @Nullable
    private UnlockableSlots getUnlockableSlots() {
        ItemStack stack = this.container.getItem(0);
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem item2 = (BackpackItem)item;
            return item2.getUnlockableSlots(stack);
        }
        return null;
    }

    private Optional<BackpackItem> getBackpackItem() {
        ItemStack backpack = this.container.getItem(0);
        Item item = backpack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem item2 = (BackpackItem)item;
            return Optional.of(item2);
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    public void setChanged() {
        super.setChanged();
        BlockEntityUtil.sendUpdatePacket(this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ShelfBlockEntity shelf) {
        if (shelf.animation >= 0 && shelf.animation < 4) {
            ++shelf.animation;
        }
        ++shelf.tickCount;
    }

    public void playAnimation() {
        if (!this.isAnimationPlaying()) {
            this.animation = 0;
        }
    }

    public boolean isAnimationPlaying() {
        return this.animation >= 0 && this.animation < 4;
    }

    public void applyAnimation(int start, int end, float partialTick, Consumer<Float> time) {
        if (this.animation < start || this.animation >= end) {
            return;
        }
        float length = end - start;
        time.accept(Float.valueOf(((float)(this.animation - start) + partialTick) / length));
    }

    public static class ShelfContainer
    extends SimpleContainer {
        private final ShelfBlockEntity shelf;

        public ShelfContainer(ShelfBlockEntity shelf) {
            super(1);
            this.shelf = shelf;
        }

        public void setChanged() {
            Level level = this.shelf.level;
            if (level instanceof ServerLevel) {
                this.shelf.setChanged();
            }
        }

        public void setItem(int slot, ItemStack stack) {
            ItemStack before = this.getItem(slot);
            Level level = this.shelf.level;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (before.isEmpty() ^ stack.isEmpty()) {
                    float pitch = stack.isEmpty() ? 0.75f : 1.0f;
                    level2.playSound(null, this.shelf.worldPosition, (SoundEvent)ModSounds.ITEM_BACKPACK_PLACE.get(), SoundSource.BLOCKS, 1.0f, pitch);
                    if (!this.shelf.loadingItems && !stack.isEmpty()) {
                        Network.getPlay().sendToTrackingBlockEntity(() -> this.shelf, (Object)new MessageShelfPlaceAnimation(this.shelf.worldPosition));
                    }
                }
            }
            super.setItem(slot, stack);
        }

        public ItemStack removeItem(int slot, int count) {
            ItemStack stack = ContainerHelper.removeItem((List)this.getItems(), (int)slot, (int)count);
            if (!stack.isEmpty()) {
                this.setChanged();
            }
            return stack;
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() instanceof BackpackItem;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public ShelfBlockEntity getShelf() {
            return this.shelf;
        }
    }

    public static class BackpackShelfContainer
    extends UnlockableContainer {
        private final ShelfBlockEntity entity;
        private final ItemStack stack;
        private final BackpackState state;

        public BackpackShelfContainer(ShelfBlockEntity entity, int size) {
            super(size);
            this.entity = entity;
            this.stack = this.entity.getBackpack();
            this.state = BackpackState.create(this.entity.getBackpack());
        }

        @Override
        protected UnlockableSlots getUnlockableSlots() {
            UnlockableSlots slots = this.entity.getUnlockableSlots();
            return slots != null ? slots : UnlockableSlots.ALL;
        }

        public void setChanged() {
            this.entity.setChanged();
        }

        @Override
        public boolean canPlaceItem(int slot, ItemStack stack) {
            return BackpackInventory.isAllowedItem(stack) && super.canPlaceItem(slot, stack);
        }

        @Override
        public boolean stillValid(Player player) {
            return this.stack == this.entity.getBackpack() && !this.entity.remove;
        }

        public ItemStack getBackpack() {
            return this.entity.getBackpack();
        }

        public ShelfBlockEntity getBlockEntity() {
            return this.entity;
        }

        public BackpackState getState() {
            return this.state;
        }
    }
}

