/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.backpacked.client.ClientBootstrap;
import com.mrcrayfish.backpacked.client.PickpocketDebugRenderer;
import com.mrcrayfish.backpacked.client.backpack.loader.ModelMetaLoader;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackManagementScreen;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackShelfScreen;
import com.mrcrayfish.backpacked.client.renderer.FirstPersonEffectsRenderer;
import com.mrcrayfish.backpacked.client.renderer.blockentity.ShelfRenderer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.VillagerBackpackLayer;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.packs.AddonRepositorySource;
import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="backpacked", dist={Dist.CLIENT})
public class ClientBackpacked {
    public ClientBackpacked(IEventBus bus) {
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onRegisterClientLoaders);
        bus.addListener(this::onRegisterMenuScreens);
        bus.addListener(this::onRegisterRenderers);
        bus.addListener(this::onAddLayers);
        bus.addListener(this::onRegisterAdditionalModels);
        bus.addListener(this::onFindPacks);
        NeoForge.EVENT_BUS.addListener(this::onRenderLevelStage);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientBootstrap.init();
            if (!FMLLoader.isProduction()) {
                NeoForge.EVENT_BUS.register((Object)new PickpocketDebugRenderer());
            }
        });
    }

    private void onRegisterClientLoaders(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ModelMetaLoader());
    }

    private void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModContainers.BACKPACK.get(), BackpackScreen::new);
        event.register((MenuType)ModContainers.MANAGEMENT.get(), BackpackManagementScreen::new);
        event.register((MenuType)ModContainers.BACKPACK_SHELF.get(), BackpackShelfScreen::new);
    }

    private void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SHELF.get(), ShelfRenderer::new);
    }

    private void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ClientBackpacked.addBackpackLayer(event.getSkin(PlayerSkin.Model.WIDE), event.getContext().getItemRenderer());
        ClientBackpacked.addBackpackLayer(event.getSkin(PlayerSkin.Model.SLIM), event.getContext().getItemRenderer());
        EntityRenderer renderer = event.getRenderer(EntityType.WANDERING_TRADER);
        if (renderer instanceof WanderingTraderRenderer) {
            WanderingTraderRenderer traderRenderer = (WanderingTraderRenderer)renderer;
            traderRenderer.addLayer(new VillagerBackpackLayer(traderRenderer, event.getContext().getItemRenderer()));
        }
    }

    private static void addBackpackLayer(EntityRenderer<?> renderer, ItemRenderer itemRenderer) {
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.addLayer(new BackpackLayer(playerRenderer, itemRenderer));
        }
    }

    private void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        Map models = manager.listResources("models/backpacked", location -> location.getPath().endsWith(".json"));
        models.forEach((key, resource) -> {
            String path = key.getPath().substring("models/".length(), key.getPath().length() - ".json".length());
            ModelResourceLocation location = FrameworkClientAPI.createModelResourceLocation((String)key.getNamespace(), (String)path);
            event.register(location);
        });
    }

    private void onFindPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path gameDir = FMLLoader.getGamePath();
            Path addonDir = gameDir.resolve("resourcepacks");
            DirectoryValidator directoryValidator = LevelStorageSource.parseValidator((Path)gameDir.resolve("allowed_symlinks.txt"));
            event.addRepositorySource((RepositorySource)new AddonRepositorySource(addonDir, PackType.SERVER_DATA, PackSource.FEATURE, directoryValidator));
        }
    }

    private void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (!mc.options.getCameraType().isFirstPerson()) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        MultiBufferSource.BufferSource source = mc.renderBuffers().bufferSource();
        boolean frozen = mc.level.tickRateManager().isEntityFrozen((Entity)mc.player);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(!frozen);
        FirstPersonEffectsRenderer.draw((AbstractClientPlayer)mc.player, stack, (MultiBufferSource)source, partialTick);
    }
}

